<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Gateway;
use Illuminate\Http\Request;

class GatewayController extends Controller
{

    public function index()
    {
        $pageTitle = 'Payment Gateway';
        $gateway   = Gateway::first();
        return view('admin.gateway.index', compact('pageTitle', 'gateway'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'minimum_deposit_limit'    => 'required|numeric|gt:0',
            'minimum_withdrawal_limit' => 'required|numeric|gt:0',
            'maximum_withdrawal_limit' => 'required|numeric|gt:minimum_withdrawal_limit',
            'public_key'               => 'required|string',
            'private_key'              => 'required|string',
        ]);

        $gateway                   = Gateway::first();
        $gateway->key_1            = $request->public_key;
        $gateway->key_2            = $request->private_key;
        $gateway->minimum_deposit  = $request->minimum_deposit_limit;
        $gateway->minimum_withdraw = $request->minimum_withdrawal_limit;
        $gateway->maximum_withdraw = $request->maximum_withdrawal_limit;
        $gateway->save();

        if ($gateway) {
            $notify[] = ['success', 'Gateway Data Updated successfully'];
            return back()->withNotify($notify);
        }
    }
}
