<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\Searchable;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class Deposit extends Model
{
    use Searchable;
    public function account()
    {
        return $this->belongsTo(Account::class, 'account_id', 'id');
    }

    public function statusBadge(): Attribute
    {
        return new Attribute(
            get: fn () => $this->badgeData(),
        );
    }

    public function badgeData()
    {
        $html = '';
        if ($this->status == Status::PAYMENT_SUCCESS) {
            $html = '<span><span class="badge badge--success">' . trans('Succeed') . '</span><br>' . diffForHumans($this->updated_at) . '</span>';
        } else if ($this->status == Status::PAYMENT_INITIATE) {
            $html = '<span class="badge badge--warning">' . trans('Initiated') . '</span>';
        }

        return $html;
    }

    public function scopeSuccessful()
    {
        return $this->where('status', Status::PAYMENT_SUCCESS);
    }

    public function scopeInitiated()
    {
        return $this->where('status', Status::PAYMENT_INITIATE);
    }
}
