
<?php $__env->startSection('content'); ?>
    <?php
        $content = getContent('user_dashboard.content', true);
    ?>

    <div class="card custom--card text--white mb-5">
        <div class="card-header py-3">
            <h5 class="card-title m-0"><?php echo app('translator')->get('Your Referral Link'); ?></h5>
        </div>

        <div class="card-body p-lg-5 p-sm-0">
            <div class="form-group m-0">
                <div class="input-group m-0">
                    <input class="form-control form--control bg-transparent" id="ref" type="url" value="<?php echo e(route('home') . '?reference=' . $account->unique_id); ?>" readonly>
                    <button class="input-group-text bg--base border--light text--white copybtn" data-copytarget="#ref" type="button"><i class="fa fa-copy"></i> &nbsp; <?php echo app('translator')->get('Copy'); ?></button>
                </div>
            </div>
        </div>
    </div>
    <div class="active--miners">
        <h4 class="subtitle mb-4 pt-5 text-white"><?php echo app('translator')->get('Your Referral Bonus Log'); ?></h4>
        <div class="table--responsive">
            <table class="cmn--table table--white">
                <thead>
                    <tr>
                        <th>
                            <?php echo app('translator')->get('Time'); ?>
                        </th>
                        <th>
                            <?php echo app('translator')->get('Account Id'); ?>
                        </th>
                        <th>
                            <?php echo app('translator')->get('Bonus'); ?>
                        </th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $referralLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <?php echo e(showDateTime($referral->created_at)); ?>

                            </td>
                            <td>
                                <span><?php echo e(@$referral->referral->unique_id); ?></span>
                            </td>
                            <td>
                                <?php echo e($referral->bonus_value); ?> <?php echo e(__($general->cur_text)); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="100%"><?php echo e($emptyMessage); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <?php if($referralLogs->hasPages()): ?>
                <?php echo e(paginateLinks($referralLogs)); ?>

            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        document.querySelectorAll('.copybtn').forEach((element) => {
            element.addEventListener('click', copy, true);
        })

        function copy(e) {
            var
                t = e.target,
                c = t.dataset.copytarget,
                inp = (c ? document.querySelector(c) : null);
            if (inp && inp.select) {
                inp.select();
                try {
                    document.execCommand('copy');
                    inp.blur();
                    t.classList.add('copied');
                    setTimeout(function() {
                        t.classList.remove('copied');
                    }, 1500);
                } catch (err) {
                    alert(`<?php echo app('translator')->get('Please press Ctrl/Cmd+C to copy'); ?>`);
                }
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/solana/public_html/core/resources/views/templates/basic/account/referrals.blade.php ENDPATH**/ ?>