@extends('admin.layouts.app')

@section('panel')
    <div class="row justify-content-center">

        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th>@lang('Date')</th>
                                    <th>@lang('Trx Number')</th>
                                    @if (!request()->routeIs('admin.account.withdrawals'))
                                        <th>@lang('Account')</th>
                                    @endif
                                    <th>@lang('Amount')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($withdrawals as $withdraw)
                                    <tr>
                                        <td>{{ showDateTime($withdraw->created_at) }}</td>
                                        <td class="fw-bold">{{ strtoupper($withdraw->trx) }}</td>
                                        @if (!request()->routeIs('admin.account.withdrawals'))
                                            <td>
                                                <a href="{{ route('admin.account.detail', $withdraw->account_id) }}">{{ @$withdraw->account->unique_id }}</a>
                                            </td>
                                        @endif
                                        <td class="budget fw-bold">{{ showAmount($withdraw->amount, 8) }} {{ __($general->cur_text) }}</td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse

                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($withdrawals->hasPages())
                    <div class="card-footer py-4">
                        {{ paginateLinks($withdrawals) }}
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection

@push('breadcrumb-plugins')
    <x-search-form dateSearch='yes' placeholder="Trx / Account" />
@endpush
