
<?php $__env->startSection('panel'); ?>
    <div class="row gy-4">
        <div class="col-12">
            <div class="row gy-4">

                <div class="col-xxl-3 col-sm-6">
                    <div class="widget-two style--two box--shadow2 b-radius--5 bg--19">
                        <div class="widget-two__icon b-radius--5 bg--primary">
                            <i class="las la-money-bill-wave-alt"></i>
                        </div>
                        <div class="widget-two__content">
                            <h3 class="text-white"><?php echo e(showAmount(@$widget['balance'], 8)); ?> <?php echo e(__($general->cur_text)); ?></h3>
                            <p class="text-white"><?php echo app('translator')->get('Balance'); ?></p>
                        </div>
                    </div>
                </div>
                <!-- dashboard-w1 end -->

                <div class="col-xxl-3 col-sm-6">
                    <div class="widget-two style--two box--shadow2 b-radius--5 bg--primary">
                        <div class="widget-two__icon b-radius--5 bg--primary">
                            <i class="las la-wallet"></i>
                        </div>
                        <div class="widget-two__content">
                            <h3 class="text-white"><?php echo e(showAmount(@$widget['deposits'], 8)); ?> <?php echo e(__($general->cur_text)); ?></h3>
                            <p class="text-white"><?php echo app('translator')->get('Deposits'); ?></p>
                        </div>
                    </div>
                </div>
                <!-- dashboard-w1 end -->

                <div class="col-xxl-3 col-sm-6">
                    <div class="widget-two style--two box--shadow2 b-radius--5 bg--1">
                        <div class="widget-two__icon b-radius--5 bg--primary">
                            <i class="fas fa-wallet"></i>
                        </div>
                        <div class="widget-two__content">
                            <h3 class="text-white"><?php echo e(showAmount(@$widget['withdrawals'], 8)); ?> <?php echo e(__($general->cur_text)); ?></h3>
                            <p class="text-white"><?php echo app('translator')->get('Withdrawals'); ?></p>
                        </div>
                    </div>
                </div>
                <!-- dashboard-w1 end -->

                <div class="col-xxl-3 col-sm-6">
                    <div class="widget-two style--two box--shadow2 b-radius--5 bg--17">
                        <div class="widget-two__icon b-radius--5 bg--primary">
                            <i class="las la-exchange-alt"></i>
                        </div>
                        <div class="widget-two__content">
                            <h3 class="text-white"><?php echo e($widget['referrals']); ?></h3>
                            <p class="text-white"><?php echo app('translator')->get('Referral'); ?></p>
                        </div>
                    </div>
                </div>
                <!-- dashboard-w1 end -->
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card b-radius--10">
                <div class="card-header">
                    <h5 class="title">
                        <?php echo app('translator')->get('Account Details'); ?>
                    </h5>
                </div>
                <div class="card-body">

                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between">
                            <strong><?php echo app('translator')->get('Unique Id'); ?></strong>
                            <span><?php echo e($account->unique_id); ?></span>
                        </li>

                        <li class="list-group-item d-flex justify-content-between">
                            <strong><?php echo app('translator')->get('Wallet'); ?></strong>
                            <span><?php echo e($account->unique_id); ?></span>
                        </li>

                        <?php if($account->ref_by): ?>
                            <li class="list-group-item d-flex justify-content-between">
                                <strong><?php echo app('translator')->get('Referred By'); ?></strong>

                                <span>
                                    <a href="<?php echo e(route('admin.account.detail', $account->ref_by)); ?>">
                                        <?php echo e($account->referral->unique_id); ?>

                                    </a>
                                </span>
                            </li>
                        <?php endif; ?>

                        <li class="list-group-item d-flex justify-content-between">
                            <strong><?php echo app('translator')->get('Status'); ?></strong>
                            <?php if($account->status): ?>
                                <span class="badge badge--success"><?php echo app('translator')->get('Activate'); ?></span>
                            <?php else: ?>
                                <span class="badge badge--danger"><?php echo app('translator')->get('Deactivated'); ?></span>
                            <?php endif; ?>
                        </li>
                    </ul>

                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card b-radius--10">
                <div class="card-header">
                    <h5 class="title"><?php echo app('translator')->get('Track Details'); ?></h5>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong><?php echo app('translator')->get('Speed'); ?></strong>
                            <span><?php echo e($account->track->speed); ?> <?php echo app('translator')->get('DH/S'); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong><?php echo app('translator')->get('Balance'); ?></strong>
                            <span><?php echo e(getAmount($account->track->balance, 8)); ?> <?php echo e(__($general->cur_text)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong><?php echo app('translator')->get('Withdraw'); ?></strong>
                            <span><?php echo e(getAmount($account->track->withdraw, 8)); ?> <?php echo e(__($general->cur_text)); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <strong><?php echo app('translator')->get('Starts From'); ?></strong>
                            <span><?php echo e(showDateTime($account->track->created_at)); ?></span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="title d-flex justify-content-between align-items-center">
                        <?php echo app('translator')->get('Latest Deposits'); ?></strong>
                        <a class="btn btn-outline--primary" href="<?php echo e(route('admin.deposit.index')); ?>?search=<?php echo e($account->unique_id); ?>"><?php echo app('translator')->get('View All'); ?></a>
                    </h5>
                </div>

                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Time'); ?></th>
                                    <th><?php echo app('translator')->get('TRX ID'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(showDateTime($item->updated_at)); ?></td>
                                        <td><?php echo e($item->trx); ?></td>
                                        <td><?php echo e(getAmount($item->amount)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-center" colspan="100%"><?php echo app('translator')->get('No deposit yet'); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="title"><?php echo app('translator')->get('Latest Withdrawals'); ?></h5>
                    <a class="btn btn-outline--primary" href="<?php echo e(route('admin.withdraw.index')); ?>?search=<?php echo e($account->unique_id); ?>"><?php echo app('translator')->get('View All'); ?></a>
                </div>

                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Time'); ?></th>
                                    <th><?php echo app('translator')->get('TRX Id'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($item->created_at); ?></td>
                                        <td><?php echo e($item->trx); ?></td>
                                        <td><?php echo e(getAmount($item->amount)); ?> <?php echo e(__($general->cur_text)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-center" colspan="100%"><?php echo app('translator')->get('No withdrawal yet'); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12">

            <div class="card b-radius--10">
                <div class="card-header">
                    <h5 class="title"><?php echo app('translator')->get('Action'); ?></h5>
                </div>
                <div class="card-body">
                    <?php if($account->status): ?>
                        <button class="h-45 btn btn--danger w-100 confirmationBtn" data-action="<?php echo e(route('admin.account.status', [$account->id, 0])); ?>" data-question="<?php echo app('translator')->get('Are you sure deactivated this account?'); ?>"><?php echo app('translator')->get('Deactive'); ?></button>
                    <?php else: ?>
                        <button class="h-45 btn btn--success w-100 confirmationBtn" data-action="<?php echo e(route('admin.account.status', [$account->id, 1])); ?>" data-question="<?php echo app('translator')->get('Are you sure activated this account?'); ?>"><?php echo app('translator')->get('Active'); ?></button>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stellar/public_html/core/resources/views/admin/account/detail.blade.php ENDPATH**/ ?>