<!DOCTYPE html>
<html class="no-js" lang="en-US">
<head>
    <meta charset="utf-8">
    <title>DigiByte Cloud Mining | 10% Daily Profit | Blockchain Secured</title>
    <meta name="description" content="Advanced DigiByte cloud mining platform with 10% daily returns. Secured by blockchain technology and smart contracts. Start mining DGB with just your wallet address.">
    <meta name="keywords" content="DigiByte Mining, DGB Mining, Cloud Mining, Crypto Mining, 10% Daily Profit, Blockchain, Smart Contracts">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5">
    <meta name="theme-color" content="#00cccc">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="msapplication-TileColor" content="#000000">
    <meta name="msapplication-config" content="<?php echo e(asset('browserconfig.xml')); ?>">
    
    <!-- Fonts & Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.1/css/all.min.css" integrity="sha512-5Hs3dF2AEPkpNAR7UiOHba+lRSJNeM2ECkwxUIxC1Q/FLycGTbNapWXB4tP889k5T5Ju8fs4b1P5z/iB4nMfSQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Orbitron:wght@400;500;700;900&family=Rajdhani:wght@300;400;500;600;700&family=Electrolize&display=swap" rel="stylesheet">
    
    <!-- Favicons - Modern Dark Theme -->
    <link rel="icon" type="image/svg+xml" href="<?php echo e(asset('favicon.svg')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('apple-touch-icon.svg')); ?>">
    <link rel="manifest" href="<?php echo e(asset('site.webmanifest')); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset('favicon.svg')); ?>">
    
    <!-- Three.js for WebGL -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/three.js/r128/three.min.js"></script>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }
        
        :root {
            --primary-cyan: #00cccc;
            --primary-blue: #0066cc;
            --primary-purple: #6a1bb2;
            --primary-pink: #cc0055;
            --success-green: #00cc00;
            --dark-bg: #000000;
            --dark-card: #0a0a0a;
        }
        
        html {
            scroll-behavior: smooth;
            font-size: 16px;
        }
        
        body {
            font-family: 'Rajdhani', sans-serif;
            background: var(--dark-bg);
            color: #ffffff;
            overflow-x: hidden;
            position: relative;
            min-height: 100vh;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
        }
        
        /* Hardware acceleration for animations */
        .cosmic-bg, .gradient-orbs, .cyber-grid, .stars-layer,
        .mining-dashboard, .stat-box, .orb {
            transform: translateZ(0);
            backface-visibility: hidden;
            perspective: 1000px;
        }
        
        /* Strong Scroll Reveal Animations */
        [data-scroll-reveal], [data-animate] {
            opacity: 0;
            transform: translateY(80px) scale(0.95);
            transition: opacity 1s cubic-bezier(0.23, 1, 0.32, 1),
                        transform 1s cubic-bezier(0.23, 1, 0.32, 1);
            will-change: opacity, transform;
        }
        
        [data-scroll-reveal].revealed,
        [data-animate].animate-in {
            opacity: 1;
            transform: translateY(0) scale(1);
        }
        
        /* Staggered animation delays for multiple items */
        [data-scroll-reveal]:nth-child(1) { transition-delay: 0s; }
        [data-scroll-reveal]:nth-child(2) { transition-delay: 0.1s; }
        [data-scroll-reveal]:nth-child(3) { transition-delay: 0.2s; }
        [data-scroll-reveal]:nth-child(4) { transition-delay: 0.3s; }
        [data-scroll-reveal]:nth-child(5) { transition-delay: 0.4s; }
        [data-scroll-reveal]:nth-child(6) { transition-delay: 0.5s; }
        
        /* Section-specific animation variations */
        .features-section [data-scroll-reveal] {
            transform: translateY(100px) scale(0.9);
        }
        
        .faq-section [data-scroll-reveal] {
            transform: translateY(60px) scale(0.98);
        }
        
        .stats-section [data-scroll-reveal] {
            transform: translateY(80px) scale(0.95);
        }
        
        .process-section [data-scroll-reveal] {
            transform: translateY(90px) scale(0.92);
        }
        
        /* Page load state */
        body:not(.page-loaded) {
            opacity: 0.95;
        }
        
        body.page-loaded {
            opacity: 1;
            transition: opacity 0.4s ease-in-out;
        }
        
        /* ==================== MULTI-LAYER ANIMATED BACKGROUND ==================== */
        .cosmic-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -5;
            background: 
                radial-gradient(ellipse at 10% 20%, rgba(0, 150, 150, 0.08) 0%, transparent 50%),
                radial-gradient(ellipse at 90% 80%, rgba(80, 25, 130, 0.08) 0%, transparent 50%),
                radial-gradient(ellipse at 50% 50%, rgba(0, 70, 140, 0.06) 0%, transparent 50%),
                linear-gradient(135deg, #000000 0%, #050508 25%, #000000 50%, #0a0a0f 75%, #000000 100%);
            background-size: 400% 400%, 400% 400%, 300% 300%, 400% 400%;
            animation: megaGradient 20s ease infinite;
        }
        
        @keyframes megaGradient {
            0%, 100% { 
                background-position: 0% 50%, 100% 50%, 50% 50%, 0% 50%; 
                filter: hue-rotate(0deg);
            }
            25% { 
                background-position: 100% 50%, 0% 50%, 25% 75%, 50% 100%;
                filter: hue-rotate(10deg);
            }
            50% { 
                background-position: 100% 100%, 0% 0%, 75% 25%, 100% 50%;
                filter: hue-rotate(20deg);
            }
            75% { 
                background-position: 0% 100%, 100% 0%, 50% 50%, 50% 0%;
                filter: hue-rotate(10deg);
            }
        }
        
        /* Animated Gradient Orbs */
        .gradient-orbs {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -4;
            overflow: hidden;
        }
        
        .orb {
            position: absolute;
            border-radius: 50%;
            filter: blur(80px);
            opacity: 0.3;
            animation: orbFloat 15s ease-in-out infinite;
        }
        
        .orb-1 {
            width: 400px;
            height: 400px;
            background: radial-gradient(circle, rgba(0, 150, 150, 0.2), transparent);
            top: -200px;
            left: -200px;
            animation-delay: 0s;
        }
        
        .orb-2 {
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, rgba(80, 25, 130, 0.15), transparent);
            bottom: -250px;
            right: -250px;
            animation-delay: 5s;
        }
        
        .orb-3 {
            width: 350px;
            height: 350px;
            background: radial-gradient(circle, rgba(0, 70, 140, 0.18), transparent);
            top: 50%;
            left: 50%;
            animation-delay: 10s;
        }
        
        .orb-4 {
            width: 300px;
            height: 300px;
            background: radial-gradient(circle, rgba(150, 0, 65, 0.15), transparent);
            top: 30%;
            right: 10%;
            animation-delay: 7s;
        }
        
        @keyframes orbFloat {
            0%, 100% { 
                transform: translate(0, 0) scale(1);
            }
            25% { 
                transform: translate(100px, -100px) scale(1.1);
            }
            50% { 
                transform: translate(-50px, 100px) scale(0.9);
            }
            75% { 
                transform: translate(-100px, -50px) scale(1.05);
            }
        }
        
        /* Animated Grid */
        .cyber-grid {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -3;
            background-image: 
                linear-gradient(rgba(0, 150, 150, 0.015) 1px, transparent 1px),
                linear-gradient(90deg, rgba(0, 150, 150, 0.015) 1px, transparent 1px);
            background-size: 50px 50px;
            animation: gridScroll 20s linear infinite;
        }
        
        @keyframes gridScroll {
            0% { transform: perspective(500px) rotateX(60deg) translateY(0); }
            100% { transform: perspective(500px) rotateX(60deg) translateY(50px); }
        }
        
        .stars-layer {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -2;
        }
        
        /* ==================== TERMINAL & MATRIX EFFECTS ==================== */
        .terminal-container {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 500px;
            max-width: calc(100vw - 40px);
            background: rgba(0, 0, 0, 0.95);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(0, 150, 150, 0.25);
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.9), 0 0 20px rgba(0, 150, 150, 0.15);
            z-index: 100;
            overflow: hidden;
            animation: terminalSlideIn 1s ease-out 2s both;
        }
        
        @keyframes terminalSlideIn {
            from { 
                transform: translateY(200px);
                opacity: 0;
            }
            to { 
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        @keyframes terminalSlideOut {
            from { 
                transform: translateY(0);
                opacity: 1;
            }
            to { 
                transform: translateY(200px);
                opacity: 0;
            }
        }
        
        .terminal-header {
            background: rgba(0, 150, 150, 0.05);
            padding: 10px 15px;
            border-bottom: 1px solid rgba(0, 150, 150, 0.2);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .terminal-title {
            display: flex;
            align-items: center;
            gap: 10px;
            font-family: 'Orbitron', monospace;
            font-size: 12px;
            color: var(--primary-cyan);
        }
        
        .terminal-buttons {
            display: flex;
            gap: 8px;
        }
        
        .terminal-btn {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .terminal-btn.minimize { background: #f5c542; }
        .terminal-btn.maximize { background: #3bb662; }
        .terminal-btn.close { background: #e85340; }
        
        .terminal-btn:hover {
            transform: scale(1.2);
            box-shadow: 0 0 10px currentColor;
        }
        
        .terminal-body {
            padding: 15px;
            height: 300px;
            overflow-y: auto;
            font-family: 'Courier New', monospace;
            font-size: 12px;
            color: #0f0;
            line-height: 1.6;
            background: rgba(0, 0, 0, 0.8);
        }
        
        .terminal-body::-webkit-scrollbar {
            width: 8px;
        }
        
        .terminal-body::-webkit-scrollbar-track {
            background: rgba(0, 0, 0, 0.3);
        }
        
        .terminal-body::-webkit-scrollbar-thumb {
            background: rgba(0, 255, 255, 0.5);
            border-radius: 4px;
        }
        
        .terminal-line {
            margin-bottom: 5px;
            opacity: 0;
            animation: terminalFadeIn 0.5s ease-out forwards;
        }
        
        @keyframes terminalFadeIn {
            from { opacity: 0; transform: translateX(-10px); }
            to { opacity: 1; transform: translateX(0); }
        }
        
        .terminal-prompt {
            color: var(--primary-cyan);
            font-weight: bold;
        }
        
        .terminal-command {
            color: #fff;
        }
        
        .terminal-output {
            color: #0f0;
        }
        
        .terminal-error {
            color: #ff4444;
        }
        
        .terminal-success {
            color: #00ff00;
        }
        
        .terminal-warning {
            color: #f5c542;
        }
        
        .terminal-cursor {
            display: inline-block;
            width: 8px;
            height: 14px;
            background: #0f0;
            margin-left: 2px;
            animation: cursorBlink 1s step-end infinite;
        }
        
        @keyframes cursorBlink {
            50% { opacity: 0; }
        }
        
        .terminal-close-btn {
            position: absolute;
            top: 10px;
            right: 10px;
            background: transparent;
            border: none;
            color: rgba(255, 255, 255, 0.8);
            font-size: 18px;
            cursor: pointer;
            transition: all 0.3s ease;
            z-index: 10;
        }
        
        .terminal-close-btn:hover {
            color: #e85340;
            transform: scale(1.2);
        }
        
        .terminal-container.minimized {
            transform: translateY(calc(100% - 50px));
        }
        
        .terminal-container.minimized .terminal-body {
            display: none;
        }
        
        /* Code Rain Effect - Mining Related */
        .matrix-rain {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            pointer-events: none;
            opacity: 0.12;
        }
        
        .matrix-column {
            position: absolute;
            top: -100%;
            font-family: 'Courier New', monospace;
            font-size: 11px;
            color: #0f0;
            text-shadow: 0 0 8px #0f0;
            animation: matrixFall linear infinite;
            white-space: pre;
            line-height: 1.4;
        }
        
        @keyframes matrixFall {
            to { top: 100%; }
        }
        
        /* Enhanced Input Container - More Visible */
        .hologram-input-container {
            position: relative;
            padding: clamp(25px, 4vw, 35px);
            margin-bottom: 50px;
            background: rgba(0, 180, 180, 0.05);
            border: 1px solid rgba(0, 180, 180, 0.2);
            border-radius: 12px;
            box-shadow: 0 8px 32px rgba(0, 180, 180, 0.1);
            transition: all 0.3s ease;
            animation: formGlow 4s ease-in-out infinite;
        }
        
        @keyframes formGlow {
            0%, 100% {
                box-shadow: 0 8px 32px rgba(0, 180, 180, 0.1);
                border-color: rgba(0, 180, 180, 0.2);
            }
            50% {
                box-shadow: 0 12px 40px rgba(0, 180, 180, 0.2);
                border-color: rgba(0, 180, 180, 0.35);
            }
        }
        
        .hologram-input-container:hover {
            background: rgba(0, 180, 180, 0.08);
            border-color: rgba(0, 180, 180, 0.4);
            box-shadow: 0 12px 40px rgba(0, 180, 180, 0.25);
        }
        
        .hologram-frame {
            display: none; /* Removed for minimal design */
        }
        
        .input-wrapper {
            position: relative;
            margin-bottom: 24px;
        }
        
        .input-scan-line {
            display: none; /* Removed for minimal design */
            pointer-events: none;
            z-index: 10;
        }
        
        @keyframes scanLine {
            0% { transform: translateY(0); opacity: 0; }
            50% { opacity: 1; }
            100% { transform: translateY(60px); opacity: 0; }
        }
        
        .wallet-input {
            width: 100%;
            padding: 20px 0;
            background: transparent;
            border: none;
            border-bottom: 2px solid rgba(0, 180, 180, 0.4);
            border-radius: 0;
            color: rgba(0, 220, 220, 1);
            font-family: 'Orbitron', monospace;
            font-size: clamp(14px, 3vw, 16px);
            font-weight: 500;
            letter-spacing: 2px;
            text-transform: uppercase;
            outline: none;
            transition: all 0.3s ease;
            position: relative;
            z-index: 5;
        }
        
        .wallet-input:focus {
            border-color: rgba(0, 200, 200, 0.7);
            box-shadow: 0 4px 12px rgba(0, 180, 180, 0.2);
            background: transparent;
        }
        
        .wallet-input::placeholder {
            color: rgba(0, 180, 180, 0.5);
            font-size: clamp(12px, 2.5vw, 14px);
            letter-spacing: 1px;
        }
        
        .input-particles {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            overflow: hidden;
            border-radius: 8px;
        }
        
        /* Duplicate .start-btn removed - using unified style below */
        
        .btn-text, .btn-hex {
            position: relative;
            z-index: 1;
        }
        
        .btn-hex {
            font-size: clamp(10px, 2.5vw, 12px);
            opacity: 0.9;
            color: rgba(0, 220, 220, 0.9);
        }
        
        /* Enhanced Label Text */
        .glitch-text {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(10px, 2.2vw, 11px);
            font-weight: 600;
            color: rgba(0, 180, 180, 0.8);
            text-align: center;
            margin-bottom: 12px;
            letter-spacing: 2px;
            text-transform: uppercase;
        }
        
        .stats-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid rgba(0, 180, 180, 0.15);
        }
        
        .sync-percentage {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(12px, 3vw, 14px);
            color: var(--success-green);
            font-weight: 700;
            animation: numberFlicker 3s infinite;
        }
        
        @keyframes numberFlicker {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }
        
        .mined-display-container {
            text-align: center;
            margin-bottom: 30px;
            padding: 20px 0;
            background: transparent;
            border-radius: 0;
            border: none;
            border-bottom: 1px solid rgba(0, 180, 180, 0.15);
        }
        
        .mined-display {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(28px, 6vw, 36px);
            font-weight: 900;
            color: var(--primary-cyan);
            margin-bottom: 5px;
            animation: numberGlow 2s ease-in-out infinite;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        
        .currency-tag {
            font-size: clamp(16px, 4vw, 20px);
            opacity: 0.95;
            color: rgba(0, 200, 200, 0.95);
            font-weight: 600;
        }
        
        /* Progress Bars */
        .hashrate-bars {
            margin-bottom: 20px;
        }
        
        .hashrate-item {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 12px;
        }
        
        .hash-label {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(10px, 2.5vw, 11px);
            color: rgba(0, 180, 180, 0.7);
            min-width: 50px;
            font-weight: 500;
        }
        
        .progress-bar {
            flex: 1;
            height: 10px;
            background: rgba(0, 0, 0, 0.6);
            border-radius: 10px;
            overflow: hidden;
            border: 1px solid rgba(0, 180, 180, 0.3);
        }
        
        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, rgba(0, 180, 180, 0.9), rgba(0, 200, 200, 0.7));
            border-radius: 10px;
            position: relative;
            overflow: hidden;
            box-shadow: 0 0 10px rgba(0, 180, 180, 0.3);
        }
        
        .progress-fill::after {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            animation: progressShine 2s linear infinite;
        }
        
        @keyframes progressShine {
            0% { left: -100%; }
            100% { left: 200%; }
        }
        
        .hash-value {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(11px, 2.5vw, 12px);
            color: rgba(0, 200, 200, 1);
            font-weight: 700;
            min-width: 80px;
            text-align: right;
        }
        
        /* Profit Ticker */
        .profit-ticker {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
            padding: 16px 12px;
            background: transparent;
            border-radius: 0;
            border: none;
            border-top: 1px solid rgba(0, 180, 180, 0.15);
            margin-top: 30px;
        }
        
        .ticker-label {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(9px, 2vw, 10px);
            color: rgba(0, 180, 180, 0.7);
            font-weight: 500;
            letter-spacing: 1.5px;
        }
        
        .ticker-separator {
            color: rgba(0, 180, 180, 0.4);
        }
        
        /* ==================== MINIMAL NAVIGATION ==================== */
        .cyber-nav {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            padding: 20px 0;
            background: rgba(0, 0, 0, 0.98);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(0, 150, 150, 0.08);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            animation: navSlideDown 0.6s ease-out;
        }
        
        @keyframes navSlideDown {
            from { transform: translateY(-100%); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        
        .cyber-nav.scrolled {
            padding: 15px 0;
            background: rgba(0, 0, 0, 1);
            box-shadow: none;
            border-bottom: 1px solid rgba(0, 150, 150, 0.12);
        }
        
        .nav-container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .nav-logo {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(18px, 4vw, 22px);
            font-weight: 600;
            color: rgba(0, 180, 180, 0.9);
            text-decoration: none;
            animation: none;
            display: flex;
            align-items: center;
            gap: 10px;
            transition: transform 0.3s ease;
            letter-spacing: 2px;
        }
        
        .nav-logo:active {
            transform: scale(0.98);
        }
        
        .nav-logo i {
            animation: logoRotate 6s linear infinite;
            font-size: 0.9em;
        }
        
        @keyframes logoRotate {
            from { transform: rotateY(0deg); }
            to { transform: rotateY(360deg); }
        }
        
        .nav-menu {
            display: flex;
            list-style: none;
            gap: 30px;
            align-items: center;
        }
        
        .nav-menu a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            font-size: 13px;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 1.5px;
            transition: all 0.3s ease;
            position: relative;
            padding: 5px 0;
        }
        
        .nav-menu a::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 1px;
            background: rgba(0, 150, 150, 0.5);
            transition: all 0.3s ease;
        }
        
        .nav-menu a:hover {
            color: rgba(0, 180, 180, 0.9);
            transform: none;
        }
        
        .nav-menu a:hover::after {
            width: 100%;
        }
        
        .nav-cta-btn {
            display: none; /* Hidden for minimal design - improves mobile logo visibility */
        }
        
        .mobile-toggle {
            display: none;
            flex-direction: column;
            gap: 5px;
            cursor: pointer;
            z-index: 100;
            padding: 10px;
        }
        
        .mobile-toggle span {
            width: 25px;
            height: 3px;
            background: var(--primary-cyan);
            border-radius: 3px;
            transition: all 0.3s ease;
        }
        
        .mobile-toggle.active span:nth-child(1) {
            transform: rotate(45deg) translate(5px, 5px);
        }
        
        .mobile-toggle.active span:nth-child(2) {
            opacity: 0;
        }
        
        .mobile-toggle.active span:nth-child(3) {
            transform: rotate(-45deg) translate(7px, -6px);
        }
        
        /* ==================== HERO SECTION ==================== */
        .hero-section {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            padding: 120px 20px 60px;
            overflow: hidden;
        }
        
        .hero-particles {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
        }
        
        .floating-elements {
            position: absolute;
            width: 100%;
            height: 100%;
            z-index: 2;
        }
        
        .float-item {
            position: absolute;
            opacity: 0.6;
            animation: floatAround 12s ease-in-out infinite;
        }
        
        @keyframes floatAround {
            0%, 100% { 
                transform: translate(0, 0) rotate(0deg) scale(1);
            }
            25% { 
                transform: translate(50px, -50px) rotate(90deg) scale(1.1);
            }
            50% { 
                transform: translate(-30px, 50px) rotate(180deg) scale(0.9);
            }
            75% { 
                transform: translate(-50px, -30px) rotate(270deg) scale(1.05);
            }
        }
        
        .float-item:nth-child(1) {
            top: 15%;
            left: 10%;
            width: 60px;
            height: 60px;
            border: 2px solid var(--primary-cyan);
            border-radius: 50%;
            box-shadow: 0 0 30px rgba(0, 255, 255, 0.5);
            animation-delay: 0s;
        }
        
        .float-item:nth-child(2) {
            top: 60%;
            right: 15%;
            width: 80px;
            height: 80px;
            border: 2px solid var(--primary-purple);
            animation-delay: 3s;
        }
        
        .float-item:nth-child(3) {
            bottom: 25%;
            left: 15%;
            width: 50px;
            height: 50px;
            border: 2px solid var(--primary-blue);
            border-radius: 10px;
            box-shadow: 0 0 25px rgba(0, 128, 255, 0.5);
            animation-delay: 6s;
        }
        
        .float-item:nth-child(4) {
            top: 35%;
            right: 20%;
            width: 70px;
            height: 70px;
            border: 2px solid var(--primary-pink);
            border-radius: 15px;
            box-shadow: 0 0 28px rgba(255, 0, 110, 0.5);
            animation-delay: 9s;
        }
        
        .hero-content {
            max-width: 1400px;
            width: 100%;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
            position: relative;
            z-index: 10;
        }
        
        .hero-left {
            animation: slideInLeft 1s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        @keyframes slideInLeft {
            from { 
                opacity: 0; 
                transform: translateX(-80px);
            }
            to { 
                opacity: 1; 
                transform: translateX(0);
            }
        }
        
        .hero-badge {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            padding: 10px 20px;
            background: rgba(0, 180, 180, 0.15);
            border: 2px solid rgba(0, 180, 180, 0.4);
            border-radius: 50px;
            margin-bottom: 25px;
            animation: badgePulse 2s ease-in-out infinite;
            backdrop-filter: blur(10px);
        }
        
        @keyframes badgePulse {
            0%, 100% { 
                box-shadow: 0 0 15px rgba(0, 180, 180, 0.3);
                transform: scale(1);
            }
            50% { 
                box-shadow: 0 0 25px rgba(0, 180, 180, 0.5);
                transform: scale(1.02);
            }
        }
        
        .live-dot {
            width: 10px;
            height: 10px;
            background: rgba(0, 200, 200, 1);
            border-radius: 50%;
            animation: blink 1s ease-in-out infinite;
            box-shadow: 0 0 10px rgba(0, 180, 180, 0.6);
        }
        
        @keyframes blink {
            0%, 100% { opacity: 1; transform: scale(1); }
            50% { opacity: 0.7; transform: scale(0.9); }
        }
        
        .hero-badge span {
            color: rgba(0, 200, 200, 1);
            font-weight: 700;
            font-size: clamp(12px, 3vw, 14px);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .hero-title {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(32px, 6vw, 52px);
            font-weight: 600;
            line-height: 1.2;
            margin-bottom: 25px;
            color: rgba(0, 180, 180, 0.95);
            animation: none;
            letter-spacing: 0.5px;
        }
        
        @keyframes titleGlow {
            0%, 100% { 
                filter: drop-shadow(0 0 30px rgba(0, 255, 255, 0.6));
            }
            50% { 
                filter: drop-shadow(0 0 50px rgba(0, 255, 255, 1));
            }
        }
        
        @keyframes gradientMove {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }
        
        .hero-subtitle {
            font-size: clamp(14px, 3.5vw, 16px);
            line-height: 1.8;
            color: rgba(255, 255, 255, 0.85);
            margin-bottom: 30px;
            animation: fadeInUp 1s ease-out 0.3s both;
            font-weight: 400;
        }
        
        @keyframes fadeInUp {
            from { 
                opacity: 0; 
                transform: translateY(30px);
            }
            to { 
                opacity: 1; 
                transform: translateY(0);
            }
        }
        
        .hero-subtitle strong {
            color: rgba(0, 200, 200, 0.9);
            font-weight: 500;
            text-shadow: none;
            animation: none;
        }
        
        .hero-features {
            display: flex;
            gap: 12px;
            flex-wrap: wrap;
            margin-bottom: 35px;
            animation: fadeInUp 1s ease-out 0.5s both;
        }
        
        .feature-tag {
            padding: 8px 0;
            background: transparent;
            border: none;
            border-bottom: 1px solid rgba(0, 180, 180, 0.3);
            border-radius: 0;
            font-size: clamp(10px, 2.5vw, 11px);
            font-weight: 500;
            color: rgba(0, 200, 200, 0.9);
            backdrop-filter: none;
            animation: none;
            transition: all 0.3s ease;
            cursor: default;
        }
        
        .feature-tag:nth-child(2) { animation-delay: 0s; }
        .feature-tag:nth-child(3) { animation-delay: 0s; }
        
        .feature-tag:hover {
            background: transparent;
            border-color: rgba(0, 180, 180, 0.5);
            transform: none;
            box-shadow: none;
        }
        
        .hero-cta-group {
            display: flex;
            gap: 15px;
            align-items: center;
            flex-wrap: wrap;
            animation: fadeInUp 1s ease-out 0.7s both;
        }
        
        .primary-cta {
            padding: 16px 35px;
            background: linear-gradient(135deg, var(--primary-cyan), var(--primary-blue), var(--primary-purple));
            background-size: 200% 200%;
            border: none;
            border-radius: 50px;
            color: white;
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(14px, 3.5vw, 16px);
            font-weight: 700;
            text-transform: uppercase;
            cursor: pointer;
            position: relative;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 255, 255, 0.5);
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
            animation: ctaPulse 3s ease-in-out infinite, gradientMove 6s ease infinite;
        }
        
        @keyframes ctaPulse {
            0%, 100% { 
                box-shadow: 0 10px 30px rgba(0, 255, 255, 0.5);
            }
            50% { 
                box-shadow: 0 15px 45px rgba(0, 255, 255, 0.8);
            }
        }
        
        .primary-cta::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            transform: translate(-50%, -50%);
            transition: width 0.6s ease, height 0.6s ease;
        }
        
        .primary-cta:hover::before {
            width: 300px;
            height: 300px;
        }
        
        .primary-cta:hover {
            transform: translateY(-5px) scale(1.05);
            box-shadow: 0 20px 50px rgba(0, 255, 255, 0.7);
        }
        
        .primary-cta:active {
            transform: translateY(-2px) scale(1);
        }
        
        .secondary-cta {
            padding: 16px 35px;
            background: transparent;
            border: 2px solid var(--primary-cyan);
            border-radius: 50px;
            color: var(--primary-cyan);
            font-family: 'Rajdhani', sans-serif;
            font-size: clamp(14px, 3.5vw, 16px);
            font-weight: 700;
            text-transform: uppercase;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-block;
            position: relative;
            overflow: hidden;
        }
        
        .secondary-cta::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: rgba(0, 255, 255, 0.2);
            transition: left 0.4s ease;
        }
        
        .secondary-cta:hover::before {
            left: 0;
        }
        
        .secondary-cta:hover {
            background: rgba(0, 255, 255, 0.1);
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(0, 255, 255, 0.3);
        }
        
        .secondary-cta:active {
            transform: translateY(-2px);
        }
        
        /* ==================== DASHBOARD CARD ==================== */
        .hero-right {
            animation: slideInRight 1s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        @keyframes slideInRight {
            from { 
                opacity: 0; 
                transform: translateX(80px);
            }
            to { 
                opacity: 1; 
                transform: translateX(0);
            }
        }
        
        .mining-dashboard {
            background: transparent;
            backdrop-filter: none;
            border-radius: 0;
            padding: 0;
            border: none;
            box-shadow: none;
            position: relative;
            overflow: visible;
            animation: none;
            transform-style: preserve-3d;
            transition: none;
            will-change: auto;
        }
        
        @keyframes dashboardFloat {
            0%, 100% { 
                transform: translateY(0);
                box-shadow: 
                    0 30px 60px rgba(0, 0, 0, 0.8), 
                    0 0 40px rgba(0, 150, 150, 0.1),
                    inset 0 0 40px rgba(0, 150, 150, 0.03);
            }
            50% { 
                transform: translateY(-20px);
                box-shadow: 
                    0 40px 80px rgba(0, 0, 0, 0.85), 
                    0 0 50px rgba(0, 150, 150, 0.2),
                    inset 0 0 50px rgba(0, 150, 150, 0.05);
            }
        }
        
        .dashboard-glow {
            display: none; /* Removed for seamless page integration */
        }
        
        @keyframes borderRotate {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        
        .dashboard-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .dashboard-title {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(24px, 5vw, 32px);
            font-weight: 700;
            color: var(--primary-cyan);
            margin-bottom: 10px;
            animation: titlePulse 2s ease-in-out infinite;
        }
        
        @keyframes titlePulse {
            0%, 100% { 
                transform: scale(1);
                text-shadow: 0 0 15px rgba(0, 150, 150, 0.4);
            }
            50% { 
                transform: scale(1.05);
                text-shadow: 0 0 25px rgba(0, 150, 150, 0.6);
            }
        }
        
        .dashboard-subtitle {
            color: rgba(255, 255, 255, 0.85);
            font-size: clamp(14px, 3vw, 16px);
            font-weight: 400;
        }
        
        .profit-showcase {
            background: transparent;
            border-radius: 0;
            padding: clamp(30px, 4vw, 40px) 0;
            margin-bottom: 30px;
            border: none;
            border-bottom: 1px solid rgba(0, 180, 180, 0.15);
            position: relative;
            overflow: visible;
            animation: none;
        }
        
        .profit-showcase::before {
            display: none;
        }
        
        @keyframes shine {
            0% { left: -100%; }
            50%, 100% { left: 200%; }
        }
        
        .profit-label {
            font-size: clamp(12px, 3vw, 14px);
            color: rgba(255, 255, 255, 0.85);
            text-transform: uppercase;
            letter-spacing: 2px;
            margin-bottom: 15px;
            font-weight: 500;
        }
        
        .profit-value {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(42px, 8vw, 56px);
            font-weight: 900;
            color: rgba(0, 200, 200, 1);
            margin-bottom: 15px;
            text-shadow: 0 0 25px rgba(0, 180, 180, 0.5);
        }
        
        @keyframes numberGlow {
            0%, 100% { 
                filter: drop-shadow(0 0 15px rgba(0, 150, 150, 0.4));
            }
            50% { 
                filter: drop-shadow(0 0 40px rgba(0, 255, 255, 1));
            }
        }
        
        .profit-badge {
            display: inline-block;
            padding: 8px 18px;
            background: rgba(0, 255, 0, 0.2);
            border: 1px solid rgba(0, 255, 0, 0.5);
            border-radius: 50px;
            color: var(--success-green);
            font-weight: 700;
            font-size: clamp(14px, 3vw, 16px);
            animation: badgeBounce 2s ease-in-out infinite;
        }
        
        @keyframes badgeBounce {
            0%, 100% { transform: translateY(0) scale(1); }
            50% { transform: translateY(-5px) scale(1.05); }
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
            margin-bottom: 25px;
        }
        
        .stat-box {
            background: transparent;
            padding: clamp(15px, 3vw, 20px) 0;
            border-radius: 0;
            border: none;
            border-bottom: 1px solid rgba(0, 180, 180, 0.15);
            text-align: center;
            transition: all 0.3s cubic-bezier(0.23, 1, 0.32, 1);
            animation: none;
            transform-style: preserve-3d;
            will-change: transform;
        }
        
        .stat-box:nth-child(2) { animation-delay: 0.5s; }
        
        .stat-box:hover {
            transform: none;
            border-color: rgba(0, 180, 180, 0.3);
            box-shadow: none;
        }
        
        .stat-label {
            font-size: clamp(11px, 2.5vw, 12px);
            color: rgba(255, 255, 255, 0.8);
            text-transform: uppercase;
            margin-bottom: 8px;
            font-weight: 500;
        }
        
        .stat-value {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(20px, 5vw, 28px);
            font-weight: 700;
            color: rgba(0, 200, 200, 1);
            text-shadow: 0 0 15px rgba(0, 180, 180, 0.4);
        }
        
        .wallet-form {
            margin-bottom: 20px;
        }
        
        /* Duplicate wallet-input removed - using unified style above */
        
        .start-btn {
            width: 100%;
            padding: clamp(20px, 4vw, 24px);
            background: rgba(0, 180, 180, 0.15);
            background-size: 200% 200%;
            border: 2px solid rgba(0, 180, 180, 0.5);
            border-radius: 8px;
            color: rgba(0, 220, 220, 1);
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(15px, 3.5vw, 17px);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 2px;
            cursor: pointer;
            box-shadow: 0 4px 20px rgba(0, 180, 180, 0.15);
            transition: all 0.3s cubic-bezier(0.23, 1, 0.32, 1);
            position: relative;
            overflow: hidden;
        }
        
        .start-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(0, 180, 180, 0.3), transparent);
            transition: left 0.5s ease;
        }
        
        .start-btn:hover::before {
            left: 100%;
        }
        
        .start-btn:hover {
            transform: translateY(-3px);
            background: rgba(0, 180, 180, 0.25);
            border-color: rgba(0, 200, 200, 0.7);
            box-shadow: 0 8px 28px rgba(0, 180, 180, 0.3);
        }
        
        .start-btn:active {
            transform: translateY(-1px);
        }
        
        .live-stats {
            text-align: center;
            padding-top: 30px;
            border-top: none;
            animation: fadeInUp 1s ease-out 1s both;
        }
        
        .live-label {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            margin-bottom: 15px;
            font-size: clamp(11px, 2.5vw, 12px);
            color: rgba(0, 180, 180, 0.7);
            font-weight: 500;
            letter-spacing: 1px;
        }
        
        .mined-display {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(28px, 6vw, 36px);
            font-weight: 900;
            color: rgba(0, 200, 200, 1);
            margin-bottom: 10px;
            animation: numberGlow 2s ease-in-out infinite;
            text-shadow: 0 0 20px rgba(0, 180, 180, 0.4);
        }
        
        .hashrate-info {
            font-size: clamp(12px, 3vw, 14px);
            color: rgba(255, 255, 255, 0.85);
            line-height: 1.6;
            font-weight: 400;
        }
        
        .hashrate-info span {
            color: rgba(0, 200, 200, 1);
            font-weight: 600;
        }
        
        /* ==================== FEATURES SECTION ==================== */
        .features-section {
            padding: clamp(60px, 10vw, 120px) clamp(20px, 5vw, 40px);
            position: relative;
            overflow: hidden;
        }
        
        .section-header {
            text-align: center;
            max-width: 800px;
            margin: 0 auto clamp(50px, 8vw, 80px);
            animation: fadeInUp 1s ease-out;
        }
        
        .section-tag {
            display: inline-block;
            padding: 8px 20px;
            background: rgba(0, 180, 180, 0.1);
            border: 1px solid rgba(0, 180, 180, 0.3);
            border-radius: 50px;
            color: var(--primary-cyan);
            font-size: clamp(12px, 3vw, 14px);
            font-weight: 600;
            text-transform: uppercase;
            margin-bottom: 20px;
            animation: tagFloat 3s ease-in-out infinite;
        }
        
        .section-title {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(24px, 5vw, 36px);
            font-weight: 600;
            color: rgba(0, 180, 180, 0.9);
            margin-bottom: 20px;
            animation: none;
            letter-spacing: 1px;
        }
        
        .section-description {
            font-size: clamp(14px, 3.5vw, 16px);
            color: rgba(255, 255, 255, 0.8);
            line-height: 1.8;
            font-weight: 400;
        }
        
        .features-grid {
            max-width: 1400px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: clamp(20px, 4vw, 30px);
        }
        
        .feature-card {
            background: transparent;
            backdrop-filter: none;
            border-radius: 0;
            padding: clamp(40px, 5vw, 50px) 0;
            border: none;
            border-bottom: 1px solid rgba(0, 180, 180, 0.15);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: visible;
            animation: cardFadeIn 0.8s ease-out;
        }
        
        @keyframes cardFadeIn {
            from { 
                opacity: 0; 
                transform: translateY(30px);
            }
            to { 
                opacity: 1; 
                transform: translateY(0);
            }
        }
        
        .feature-card::before {
            display: none;
        }
        
        .feature-card:hover {
            transform: none;
            border-color: rgba(0, 180, 180, 0.3);
            box-shadow: none;
        }
        
        .feature-card:hover::before {
            opacity: 0;
        }
        
        .feature-icon {
            width: clamp(50px, 10vw, 60px);
            height: clamp(50px, 10vw, 60px);
            background: rgba(0, 180, 180, 0.1);
            border: 2px solid rgba(0, 180, 180, 0.4);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: clamp(24px, 5vw, 28px);
            margin-bottom: 25px;
            color: rgba(0, 200, 200, 1);
            box-shadow: 0 5px 15px rgba(0, 180, 180, 0.2);
            animation: none;
        }
        
        .feature-icon:hover {
            transform: scale(1.05);
            border-color: rgba(0, 200, 200, 0.6);
        }
        
        .feature-title {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(18px, 4vw, 22px);
            font-weight: 600;
            color: rgba(0, 200, 200, 1);
            margin-bottom: 15px;
            letter-spacing: 0.5px;
        }
        
        .feature-description {
            font-size: clamp(14px, 3vw, 16px);
            color: rgba(255, 255, 255, 0.85);
            line-height: 1.7;
            font-weight: 400;
        }
        
        /* ==================== STATS SECTION ==================== */
        .stats-section {
            padding: clamp(60px, 10vw, 100px) clamp(20px, 5vw, 40px);
            background: transparent;
            border-top: 1px solid rgba(0, 180, 180, 0.15);
            border-bottom: 1px solid rgba(0, 180, 180, 0.15);
            position: relative;
            overflow: hidden;
        }
        
        .stats-container {
            max-width: 1400px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: clamp(20px, 4vw, 40px);
        }
        
        .stat-item {
            text-align: center;
            animation: fadeInUp 1s ease-out;
            transition: transform 0.3s ease;
        }
        
        .stat-item:hover {
            transform: translateY(-10px);
        }
        
        .stat-number {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(42px, 8vw, 56px);
            font-weight: 900;
            color: rgba(0, 200, 200, 1);
            margin-bottom: 10px;
            text-shadow: 0 0 20px rgba(0, 180, 180, 0.5);
        }
        
        .stat-text {
            font-size: clamp(14px, 3vw, 16px);
            color: rgba(255, 255, 255, 0.85);
            text-transform: uppercase;
            letter-spacing: 2px;
            font-weight: 500;
        }
        
        /* ==================== PROCESS SECTION ==================== */
        .process-section {
            padding: clamp(60px, 10vw, 120px) clamp(20px, 5vw, 40px);
        }
        
        .process-steps {
            max-width: 1400px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: clamp(30px, 5vw, 40px);
        }
        
        .step-card {
            text-align: center;
            position: relative;
            animation: fadeInUp 1s ease-out;
            padding: clamp(30px, 4vw, 40px) 0;
            background: transparent;
            border-radius: 0;
            border: none;
            border-bottom: 1px solid rgba(0, 180, 180, 0.15);
            transition: all 0.3s ease;
        }
        
        .step-card:hover {
            transform: none;
            border-color: rgba(0, 180, 180, 0.3);
            box-shadow: none;
        }
        
        .step-number {
            width: clamp(50px, 10vw, 60px);
            height: clamp(50px, 10vw, 60px);
            background: transparent;
            border: 2px solid rgba(0, 180, 180, 0.4);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(24px, 5vw, 28px);
            font-weight: 700;
            margin: 0 auto 25px;
            color: rgba(0, 200, 200, 1);
            box-shadow: none;
            animation: none;
        }
        
        .step-title {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(18px, 4vw, 22px);
            font-weight: 600;
            color: rgba(0, 200, 200, 1);
            margin-bottom: 15px;
            letter-spacing: 0.5px;
        }
        
        .step-description {
            font-size: clamp(14px, 3vw, 16px);
            color: rgba(255, 255, 255, 0.85);
            line-height: 1.7;
            font-weight: 400;
        }
        
        /* ==================== FAQ SECTION ==================== */
        .faq-section {
            padding: clamp(60px, 10vw, 120px) clamp(20px, 5vw, 40px);
            background: rgba(26, 31, 58, 0.3);
        }
        
        .faq-container {
            max-width: 900px;
            margin: 0 auto;
        }
        
        .faq-item {
            background: rgba(26, 31, 58, 0.7);
            backdrop-filter: blur(20px);
            border-radius: 15px;
            padding: clamp(20px, 4vw, 30px);
            margin-bottom: 20px;
            border: 1px solid rgba(0, 255, 255, 0.2);
            cursor: pointer;
            transition: all 0.3s ease;
            animation: fadeInUp 0.6s ease-out;
        }
        
        .faq-item:hover {
            border-color: var(--primary-cyan);
            transform: translateX(10px);
            box-shadow: 0 10px 30px rgba(0, 255, 255, 0.3);
        }
        
        .faq-question {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(16px, 4vw, 20px);
            font-weight: 700;
            color: var(--primary-cyan);
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 15px;
        }
        
        .faq-question i {
            transition: transform 0.3s ease;
        }
        
        .faq-item:hover .faq-question i {
            transform: rotate(180deg);
        }
        
        .faq-answer {
            font-size: clamp(14px, 3vw, 16px);
            color: rgba(255, 255, 255, 0.8);
            line-height: 1.6;
            margin-top: 15px;
            padding-top: 15px;
            border-top: 1px solid rgba(0, 255, 255, 0.1);
        }
        
        /* ==================== MINIMAL FOOTER ==================== */
        .footer-section {
            padding: clamp(80px, 12vw, 120px) clamp(20px, 5vw, 40px) clamp(40px, 6vw, 60px);
            background: transparent;
            border-top: 1px solid rgba(0, 150, 150, 0.08);
        }
        
        .footer-container {
            max-width: 1400px;
            margin: 0 auto;
        }
        
        .footer-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: clamp(40px, 6vw, 80px);
            margin-bottom: clamp(50px, 8vw, 80px);
        }
        
        .footer-brand {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(20px, 4vw, 26px);
            font-weight: 600;
            color: rgba(0, 180, 180, 0.9);
            margin-bottom: 20px;
            letter-spacing: 2px;
        }
        
        .footer-description {
            color: rgba(255, 255, 255, 0.75);
            line-height: 1.8;
            margin-bottom: 25px;
            font-size: clamp(13px, 2.5vw, 14px);
            font-weight: 400;
        }
        
        .social-links {
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
        }
        
        .social-link {
            width: 40px;
            height: 40px;
            background: transparent;
            border: 1px solid rgba(0, 150, 150, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: rgba(0, 150, 150, 0.7);
            text-decoration: none;
            transition: all 0.3s ease;
            animation: none;
        }
        
        .social-link:hover {
            background: transparent;
            color: rgba(0, 180, 180, 1);
            border-color: rgba(0, 150, 150, 0.5);
            transform: translateY(-2px);
            box-shadow: none;
        }
        
        .social-link:active {
            transform: translateY(0);
        }
        
        .footer-title {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(13px, 3vw, 15px);
            font-weight: 500;
            color: rgba(0, 180, 180, 0.8);
            margin-bottom: 25px;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        
        .footer-links {
            list-style: none;
        }
        
        .footer-links li {
            margin-bottom: 15px;
        }
        
        .footer-links a {
            color: rgba(255, 255, 255, 0.7);
            text-decoration: none;
            transition: all 0.3s ease;
            font-size: clamp(13px, 2.5vw, 14px);
            display: inline-block;
            font-weight: 400;
        }
        
        .footer-links a:hover {
            color: rgba(0, 180, 180, 0.9);
            transform: translateX(3px);
        }
        
        .footer-bottom {
            text-align: center;
            padding-top: clamp(40px, 6vw, 60px);
            border-top: 1px solid rgba(0, 150, 150, 0.08);
            color: rgba(255, 255, 255, 0.6);
            font-size: clamp(11px, 2.5vw, 12px);
            font-weight: 400;
        }
        
        /* ==================== MOBILE RESPONSIVE ==================== */
        @media (max-width: 968px) {
            .hero-content {
                grid-template-columns: 1fr;
                gap: 40px;
            }
            
            .terminal-container {
                bottom: 10px;
                right: 10px;
                left: 10px;
                width: auto;
                max-width: none;
            }
            
            .terminal-body {
                height: 200px;
                font-size: 10px;
            }
            
            .terminal-title span {
                font-size: 10px;
            }
            
            .matrix-rain {
                opacity: 0.08; /* Lighter on mobile */
            }
            
            .nav-menu {
                position: fixed;
                top: 70px;
                left: -100%;
                width: 100%;
                height: calc(100vh - 70px);
                background: rgba(0, 0, 0, 0.98);
                backdrop-filter: blur(10px);
                flex-direction: column;
                justify-content: flex-start;
                padding: 40px 20px;
                gap: 0;
                transition: left 0.4s cubic-bezier(0.4, 0, 0.2, 1);
                z-index: 999;
            }
            
            .nav-menu.active {
                left: 0;
            }
            
            .nav-menu a {
                font-size: 16px;
                width: 100%;
                text-align: center;
                padding: 20px 15px;
                background: transparent;
                border-radius: 0;
                border-bottom: 1px solid rgba(0, 150, 150, 0.08);
            }
            
            .mobile-toggle {
                display: flex;
            }
            
            .floating-elements {
                opacity: 0.4; /* Visible but subtle on mobile */
            }
            
            .cyber-grid {
                opacity: 0.5; /* Keep grid visible */
            }
            
            .orb {
                filter: blur(60px); /* Less blur for visibility */
                opacity: 0.4; /* More visible on mobile */
            }
            
            .orb-1 {
                background: radial-gradient(circle, rgba(0, 180, 180, 0.3), transparent);
            }
            
            .orb-2 {
                background: radial-gradient(circle, rgba(100, 35, 150, 0.25), transparent);
            }
            
            .orb-3 {
                background: radial-gradient(circle, rgba(0, 90, 170, 0.28), transparent);
            }
            
            .orb-4 {
                background: radial-gradient(circle, rgba(180, 0, 80, 0.25), transparent);
            }
            
            .cosmic-bg {
                background: 
                    radial-gradient(ellipse at 10% 20%, rgba(0, 180, 180, 0.15) 0%, transparent 50%),
                    radial-gradient(ellipse at 90% 80%, rgba(100, 35, 150, 0.15) 0%, transparent 50%),
                    radial-gradient(ellipse at 50% 50%, rgba(0, 90, 170, 0.12) 0%, transparent 50%),
                    linear-gradient(135deg, #000000 0%, #0a0a0f 25%, #000000 50%, #0f0f15 75%, #000000 100%);
                animation-duration: 25s; /* Slower animation on mobile for smoother performance */
            }
            
            .orb {
                animation-duration: 18s; /* Slower, smoother orbit on mobile */
            }
            
            .hero-section {
                padding: 100px 15px 40px;
            }
            
            .hero-cta-group {
                width: 100%;
            }
            
            .primary-cta,
            .secondary-cta {
                width: 100%;
                text-align: center;
                justify-content: center;
            }
            
            .features-grid {
                grid-template-columns: 1fr;
            }
            
            .stats-container {
                grid-template-columns: repeat(2, 1fr);
                gap: 20px;
            }
            
            .process-steps {
                grid-template-columns: 1fr;
            }
            
            .footer-grid {
                grid-template-columns: 1fr;
            }
            
            .trust-grid,
            .metrics-grid {
                grid-template-columns: repeat(2, 1fr);
                gap: 20px;
            }
            
            .testimonials-grid {
                grid-template-columns: 1fr;
            }
            
            .activity-item {
                flex-direction: column;
                align-items: flex-start;
                gap: 15px;
            }
            
            .activity-time {
                width: 100%;
                text-align: left;
            }
            
            .cta-stats {
                gap: 15px;
            }
            
            .cta-stat-divider {
                display: none;
            }
            
            .comparison-row {
                grid-template-columns: 1fr 1fr 1fr;
                gap: 10px;
                font-size: 11px;
            }
            
            .spec-row {
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
            }
            
            .spec-value {
                text-align: left;
            }
        }
        
        @media (max-width: 480px) {
            html {
                font-size: 14px;
            }
            
            .stats-container {
                grid-template-columns: 1fr;
            }
            
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .hologram-frame > div {
                width: 15px;
                height: 15px;
            }
            
            .ticker-label {
                font-size: 8px;
            }
            
            .mined-display {
                flex-direction: column;
                gap: 5px;
            }
            
            .trust-grid,
            .metrics-grid {
                grid-template-columns: 1fr;
            }
            
            .comparison-row {
                grid-template-columns: 1fr;
                gap: 8px;
            }
            
            .comparison-cell {
                text-align: left;
                padding: 5px 0;
            }
            
            .comparison-cell:first-child {
                font-weight: 700;
                color: rgba(0, 180, 180, 0.9);
            }
            
            /* Enhanced background on small screens */
            .orb {
                opacity: 0.45; /* Even more visible */
            }
            
            .cosmic-bg {
                background: 
                    radial-gradient(ellipse at 10% 20%, rgba(0, 180, 180, 0.18) 0%, transparent 50%),
                    radial-gradient(ellipse at 90% 80%, rgba(100, 35, 150, 0.18) 0%, transparent 50%),
                    radial-gradient(ellipse at 50% 50%, rgba(0, 90, 170, 0.15) 0%, transparent 50%),
                    linear-gradient(135deg, #000000 0%, #0f0f12 25%, #000000 50%, #12121a 75%, #000000 100%);
            }
        }
        
        /* ==================== SCROLL ANIMATIONS ==================== */
        /* Animations defined in main styles above */
        
        /* ==================== LOADING ANIMATION ==================== */
        @keyframes pageLoad {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        body {
            animation: pageLoad 0.5s ease-out;
        }
        
        /* Touch-friendly improvements */
        @media (hover: none) and (pointer: coarse) {
            .feature-card,
            .stat-box,
            .step-card {
                transform: none !important;
            }
            
            .feature-card:active,
            .stat-box:active,
            .step-card:active {
                transform: scale(0.98) !important;
            }
        }
        
        /* ==================== LIVE ACTIVITY SECTION ==================== */
        .activity-section {
            padding: clamp(60px, 10vw, 100px) 20px;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .activity-feed {
            display: flex;
            flex-direction: column;
            gap: 0;
            margin-top: 40px;
        }
        
        .activity-item {
            display: flex;
            align-items: center;
            gap: 20px;
            padding: 20px 0;
            border-bottom: 1px solid rgba(0, 180, 180, 0.1);
            transition: all 0.3s ease, opacity 0.3s ease;
        }
        
        .activity-item:hover {
            border-color: rgba(0, 180, 180, 0.2);
        }
        
        .activity-icon {
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 1px solid rgba(0, 180, 180, 0.3);
            border-radius: 50%;
            color: rgba(0, 200, 200, 1);
            font-size: 16px;
        }
        
        .activity-content {
            flex: 1;
        }
        
        .activity-wallet {
            font-family: 'Orbitron', monospace;
            font-size: clamp(12px, 2.5vw, 14px);
            color: rgba(255, 255, 255, 0.85);
            margin-bottom: 5px;
            font-weight: 500;
        }
        
        .activity-action {
            font-size: clamp(11px, 2.2vw, 12px);
            color: rgba(255, 255, 255, 0.6);
            font-weight: 400;
        }
        
        .activity-amount {
            color: rgba(0, 200, 200, 1);
            font-weight: 600;
        }
        
        .activity-time {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(10px, 2vw, 11px);
            color: rgba(255, 255, 255, 0.5);
            min-width: 80px;
            text-align: right;
        }
        
        /* ==================== TECHNICAL SPECIFICATIONS SECTION ==================== */
        .tech-specs-section {
            padding: clamp(60px, 10vw, 100px) 20px;
            max-width: 1000px;
            margin: 0 auto;
        }
        
        .specs-grid {
            display: flex;
            flex-direction: column;
            gap: 0;
            margin-top: 40px;
        }
        
        .spec-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: clamp(18px, 3vw, 25px) 0;
            border-bottom: 1px solid rgba(0, 180, 180, 0.1);
            transition: all 0.3s ease;
            gap: 20px;
            position: relative;
        }
        
        .spec-row::before {
            content: '';
            position: absolute;
            left: 0;
            bottom: -1px;
            width: 0;
            height: 1px;
            background: rgba(0, 200, 200, 0.6);
            transition: width 0.4s ease;
        }
        
        .spec-row:hover {
            border-color: rgba(0, 180, 180, 0.25);
        }
        
        .spec-row:hover::before {
            width: 100%;
        }
        
        .spec-label {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(12px, 2.8vw, 14px);
            color: rgba(255, 255, 255, 0.8);
            font-weight: 500;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        
        .spec-value {
            font-family: 'Orbitron', monospace;
            font-size: clamp(12px, 2.8vw, 14px);
            color: rgba(0, 200, 200, 1);
            font-weight: 600;
            text-align: right;
        }
        
        /* ==================== TRUST & SECURITY SECTION ==================== */
        .trust-section {
            padding: clamp(60px, 10vw, 100px) 20px;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .trust-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: clamp(30px, 5vw, 50px);
            margin-top: 40px;
        }
        
        .trust-item {
            text-align: center;
            padding: clamp(30px, 4vw, 40px) 0;
            border-bottom: 1px solid rgba(0, 180, 180, 0.1);
            transition: all 0.3s ease;
        }
        
        .trust-item:hover {
            border-color: rgba(0, 180, 180, 0.3);
        }
        
        .trust-icon {
            width: 60px;
            height: 60px;
            margin: 0 auto 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 2px solid rgba(0, 180, 180, 0.4);
            border-radius: 50%;
            font-size: 24px;
            color: rgba(0, 200, 200, 1);
        }
        
        .trust-metric {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(20px, 4vw, 28px);
            font-weight: 700;
            color: rgba(0, 200, 200, 1);
            margin-bottom: 10px;
            letter-spacing: 1px;
        }
        
        .trust-label {
            font-size: clamp(12px, 2.5vw, 14px);
            color: rgba(255, 255, 255, 0.75);
            text-transform: uppercase;
            letter-spacing: 1px;
            font-weight: 400;
        }
        
        /* ==================== COMPARISON SECTION ==================== */
        .comparison-section {
            padding: clamp(60px, 10vw, 100px) 20px;
            max-width: 1000px;
            margin: 0 auto;
        }
        
        .comparison-table {
            margin-top: 40px;
            display: flex;
            flex-direction: column;
            gap: 0;
        }
        
        .comparison-row {
            display: grid;
            grid-template-columns: 2fr 1fr 1fr;
            gap: 20px;
            padding: clamp(18px, 3vw, 22px) 0;
            border-bottom: 1px solid rgba(0, 180, 180, 0.1);
            transition: all 0.3s ease;
        }
        
        .comparison-row:hover {
            border-color: rgba(0, 180, 180, 0.2);
        }
        
        .comparison-header {
            border-bottom: 2px solid rgba(0, 180, 180, 0.3);
        }
        
        .comparison-cell {
            font-size: clamp(12px, 2.8vw, 14px);
            font-weight: 500;
            color: rgba(255, 255, 255, 0.8);
            text-align: center;
        }
        
        .comparison-cell:first-child {
            text-align: left;
            font-family: 'Orbitron', sans-serif;
            letter-spacing: 1px;
        }
        
        .comparison-header .comparison-cell {
            font-family: 'Orbitron', sans-serif;
            font-weight: 700;
            color: rgba(0, 200, 200, 1);
            text-transform: uppercase;
            letter-spacing: 1px;
            font-size: clamp(11px, 2.5vw, 13px);
        }
        
        .comparison-cell.highlight {
            color: rgba(0, 200, 200, 1);
            font-weight: 700;
            font-family: 'Orbitron', sans-serif;
        }
        
        .comparison-cell.dim {
            color: rgba(255, 255, 255, 0.4);
            font-weight: 400;
        }
        
        /* ==================== TESTIMONIALS SECTION ==================== */
        .testimonials-section {
            padding: clamp(60px, 10vw, 100px) 20px;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .testimonials-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: clamp(25px, 4vw, 35px);
            margin-top: 40px;
        }
        
        .testimonial-card {
            background: transparent;
            padding: clamp(30px, 4vw, 40px) 0;
            border-bottom: 1px solid rgba(0, 180, 180, 0.1);
            transition: all 0.3s ease;
            position: relative;
        }
        
        .testimonial-card::before {
            content: '';
            position: absolute;
            left: 0;
            bottom: -1px;
            width: 0;
            height: 1px;
            background: rgba(0, 200, 200, 0.6);
            transition: width 0.5s ease;
        }
        
        .testimonial-card:hover {
            border-color: rgba(0, 180, 180, 0.25);
        }
        
        .testimonial-card:hover::before {
            width: 100%;
        }
        
        .testimonial-stars {
            display: flex;
            gap: 5px;
            margin-bottom: 20px;
            font-size: 14px;
            color: rgba(0, 200, 200, 1);
        }
        
        .testimonial-text {
            font-size: clamp(13px, 2.8vw, 15px);
            line-height: 1.8;
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 25px;
            font-weight: 400;
            font-style: italic;
        }
        
        .testimonial-author {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .author-avatar {
            width: 45px;
            height: 45px;
            background: rgba(0, 180, 180, 0.15);
            border: 2px solid rgba(0, 180, 180, 0.4);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Orbitron', sans-serif;
            font-weight: 700;
            font-size: 14px;
            color: rgba(0, 200, 200, 1);
        }
        
        .author-name {
            font-weight: 600;
            color: rgba(255, 255, 255, 0.85);
            font-size: clamp(13px, 2.5vw, 15px);
            margin-bottom: 3px;
        }
        
        .author-wallet {
            font-family: 'Orbitron', monospace;
            font-size: clamp(10px, 2vw, 11px);
            color: rgba(0, 180, 180, 0.7);
        }
        
        /* ==================== METRICS SECTION ==================== */
        .metrics-section {
            padding: clamp(60px, 10vw, 100px) 20px;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .metrics-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: clamp(25px, 4vw, 40px);
            margin-top: 40px;
        }
        
        .metric-box {
            text-align: center;
            padding: clamp(30px, 4vw, 40px) 0;
            border-bottom: 1px solid rgba(0, 180, 180, 0.1);
            transition: all 0.3s ease;
        }
        
        .metric-box:hover {
            border-color: rgba(0, 180, 180, 0.3);
        }
        
        .metric-icon {
            font-size: clamp(32px, 6vw, 42px);
            margin-bottom: 15px;
        }
        
        .metric-value {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(28px, 5vw, 38px);
            font-weight: 700;
            color: rgba(0, 200, 200, 1);
            margin-bottom: 10px;
            text-shadow: 0 0 15px rgba(0, 180, 180, 0.3);
        }
        
        .metric-label {
            font-size: clamp(11px, 2.5vw, 13px);
            color: rgba(255, 255, 255, 0.75);
            text-transform: uppercase;
            letter-spacing: 1px;
            font-weight: 400;
        }
        
        /* ==================== FINAL CTA SECTION ==================== */
        .final-cta-section {
            padding: clamp(80px, 12vw, 120px) 20px;
            max-width: 900px;
            margin: 0 auto;
            text-align: center;
        }
        
        .cta-content {
            padding: clamp(40px, 6vw, 60px);
            background: rgba(0, 180, 180, 0.05);
            border: 1px solid rgba(0, 180, 180, 0.2);
            border-radius: 12px;
            transition: all 0.3s ease;
        }
        
        .cta-content:hover {
            background: rgba(0, 180, 180, 0.08);
            border-color: rgba(0, 180, 180, 0.3);
        }
        
        .cta-title {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(28px, 6vw, 42px);
            font-weight: 700;
            color: rgba(0, 200, 200, 1);
            margin-bottom: 20px;
            letter-spacing: 1px;
        }
        
        .cta-description {
            font-size: clamp(14px, 3vw, 16px);
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 40px;
            line-height: 1.7;
            font-weight: 400;
        }
        
        .cta-stats {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 30px;
            margin-bottom: 40px;
            flex-wrap: wrap;
        }
        
        .cta-stat {
            text-align: center;
        }
        
        .cta-stat-value {
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(24px, 5vw, 32px);
            font-weight: 700;
            color: rgba(0, 200, 200, 1);
            margin-bottom: 8px;
        }
        
        .cta-stat-label {
            font-size: clamp(10px, 2vw, 11px);
            color: rgba(255, 255, 255, 0.7);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .cta-stat-divider {
            width: 1px;
            height: 40px;
            background: rgba(0, 180, 180, 0.2);
        }
        
        .cta-button {
            display: inline-flex;
            align-items: center;
            gap: 12px;
            padding: clamp(18px, 4vw, 22px) clamp(35px, 6vw, 50px);
            background: rgba(0, 180, 180, 0.2);
            border: 2px solid rgba(0, 180, 180, 0.5);
            border-radius: 8px;
            color: rgba(0, 220, 220, 1);
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(14px, 3vw, 16px);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 2px;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.23, 1, 0.32, 1);
            box-shadow: 0 4px 20px rgba(0, 180, 180, 0.2);
        }
        
        .cta-button:hover {
            transform: translateY(-3px);
            background: rgba(0, 180, 180, 0.3);
            border-color: rgba(0, 200, 200, 0.7);
            box-shadow: 0 8px 32px rgba(0, 180, 180, 0.3);
        }
        
        .cta-button i {
            transition: transform 0.3s ease;
        }
        
        .cta-button:hover i {
            transform: translateX(5px);
        }
        
        /* ==================== MINIMAL FAQ SECTION STYLING ==================== */
        .faq-section {
            padding: clamp(60px, 10vw, 100px) 20px;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .faq-container {
            display: flex;
            flex-direction: column;
            gap: 0;
        }
        
        .faq-item {
            background: transparent;
            border: none;
            border-bottom: 1px solid rgba(0, 180, 180, 0.15);
            padding: clamp(25px, 4vw, 35px) 0;
            transition: all 0.3s ease;
        }
        
        .faq-question {
            width: 100%;
            background: transparent;
            border: none;
            color: rgba(0, 180, 180, 0.9);
            font-family: 'Orbitron', sans-serif;
            font-size: clamp(14px, 3vw, 18px);
            font-weight: 500;
            text-align: left;
            padding: 0;
            cursor: pointer;
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
            letter-spacing: 0.5px;
        }
        
        .faq-question:hover {
            color: rgba(0, 200, 200, 1);
        }
        
        .faq-question i {
            color: rgba(0, 150, 150, 0.5);
            font-size: clamp(14px, 3vw, 16px);
            transition: transform 0.3s ease;
        }
        
        .faq-item.active .faq-question i {
            transform: rotate(180deg);
        }
        
        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s cubic-bezier(0.23, 1, 0.32, 1),
                        opacity 0.4s ease,
                        padding 0.4s ease;
            padding: 0;
            opacity: 0;
        }
        
        .faq-item.active .faq-answer {
            max-height: 500px;
            padding-top: 20px;
            opacity: 1;
        }
        
        .faq-answer p {
            color: rgba(255, 255, 255, 0.8);
            font-size: clamp(13px, 2.5vw, 15px);
            line-height: 1.8;
            font-weight: 400;
            margin: 0;
        }
    </style>
</head>

<body id="top">
    <!-- Multi-Layer Animated Background -->
    <div class="cosmic-bg"></div>
    
    <div class="gradient-orbs">
        <div class="orb orb-1"></div>
        <div class="orb orb-2"></div>
        <div class="orb orb-3"></div>
        <div class="orb orb-4"></div>
            </div>
			
    <div class="cyber-grid"></div>
    <canvas class="stars-layer" id="stars"></canvas>
    
    <!-- Matrix Rain Effect -->
    <div class="matrix-rain" id="matrixRain"></div>
    
    <!-- Linux Terminal Window -->
    <div class="terminal-container" id="terminal">
        <div class="terminal-header">
            <div class="terminal-title">
                <i class="fas fa-terminal"></i>
                <span>dgb-miner@blockchain:~</span>
                        </div>
            <div class="terminal-buttons">
                <div class="terminal-btn minimize" onclick="minimizeTerminal()"></div>
                <div class="terminal-btn maximize" onclick="maximizeTerminal()"></div>
                <div class="terminal-btn close" onclick="closeTerminal()"></div>
                    </div>
                        </div>
        <div class="terminal-body" id="terminalBody"></div>
                    </div>
					
    <!-- Navigation -->
    <nav class="cyber-nav" id="navbar">
        <div class="nav-container">
            <a href="#top" class="nav-logo">
                <i class="fas fa-cube"></i>
                DGB MINING
            </a>
            
            <ul class="nav-menu" id="navMenu">
                <li><a href="#features">Features</a></li>
                <li><a href="#how-it-works">How It Works</a></li>
                <li><a href="#activity">Live Activity</a></li>
                <li><a href="#trust">Security</a></li>
                <li><a href="#testimonials">Reviews</a></li>
                <li><a href="#faq">FAQ</a></li>
            </ul>
            
            <div class="mobile-toggle" id="mobileToggle">
                <span></span>
                <span></span>
                <span></span>
                        </div>
		
            <a href="#start-mining" class="nav-cta-btn">START MINING</a>
                    </div>
    </nav>
    
    <!-- Hero Section -->
    <section class="hero-section" id="start-mining">
        <canvas class="hero-particles" id="heroParticles"></canvas>
        
        <div class="floating-elements">
            <div class="float-item"></div>
            <div class="float-item"></div>
            <div class="float-item"></div>
            <div class="float-item"></div>
		      </div>
		
        <div class="hero-content">
            <div class="hero-left">
                <div class="hero-badge">
                    <span class="live-dot"></span>
                    <span>LIVE MINING PLATFORM</span>
                    </div>
					
                <h1 class="hero-title">
                    Mine DigiByte<br>
                    Earn 10% Daily<br>
                    Profit
                </h1>
                
                <p class="hero-subtitle">
                    Join the most advanced blockchain-secured crypto mining platform. 
                    Connect your wallet address and start earning <strong>up to 10% daily returns</strong> 
                    through our cutting-edge DGB mining infrastructure powered by smart contracts.
                </p>
                
                <div class="hero-features">
                    <div class="feature-tag">🔒 Blockchain Secured</div>
                    <div class="feature-tag">⚡ Smart Contracts</div>
                    <div class="feature-tag">💎 Instant Payouts</div>
                    </div>
					
                    </div>
                    
            <div class="hero-right">
                <div class="mining-dashboard">
                    <div class="dashboard-glow"></div>
                    
                    <!-- Minimal Wallet Input -->
                    <div class="hologram-input-container">
                        <form class="wallet-form" id="loginForm" action="#">
                            <?php echo csrf_field(); ?>
                            <div class="input-wrapper">
                                <input 
                                    class="wallet-input" 
                                    name="wallet" 
                                    type="text" 
                                    placeholder="WALLET ADDRESS REQUIRED"
                                    required
                                    id="walletInput"
                                >
                                <div class="input-particles" id="inputParticles"></div>
                        </div>
                            <button class="start-btn" type="submit">
                                <span class="btn-text">INITIATE MINING PROTOCOL</span>
                                <span class="btn-hex">0xMINE</span>
                            </button>
                        </form>
                    </div>
					
                    <!-- Live Counter Display -->
                    <div class="live-stats">
                        <div class="stats-header">
                            <div class="live-label">
                                <span class="live-dot"></span>
                                <span>BLOCKCHAIN SYNC</span>
                        </div>
                            <div class="sync-percentage" id="syncPercent">98.7%</div>
                    </div>
					
                        <div class="mined-display-container">
                            <div class="glitch-text" data-text="MINING OUTPUT">MINING OUTPUT</div>
                            <div class="mined-display">
                                <span id="mined">0.00000000</span> 
                                <span class="currency-tag"><?php echo e(__($general->cur_text)); ?></span>
                        </div>
                    </div>
					
                        <div class="hashrate-bars">
                            <div class="hashrate-item">
                                <span class="hash-label">SPEED:</span>
                                <div class="progress-bar">
                                    <div class="progress-fill" style="width: 100%"></div>
                        </div>
                                <span class="hash-value">100% DH/S</span>
                    </div>
                            <div class="hashrate-item">
                                <span class="hash-label">RATE:</span>
                                <div class="progress-bar">
                                    <div class="progress-fill" style="width: 85%"></div>
                                </div>
                                <span class="hash-value" id="dailyProfit"><?php echo e(5000 * $general->daily_earning); ?></span>
                        </div>
                    </div>
					
                        <div class="profit-ticker">
                            <span class="ticker-label">10% APD</span>
                            <span class="ticker-separator">|</span>
                            <span class="ticker-label">BLOCKCHAIN SECURED</span>
                            <span class="ticker-separator">|</span>
                            <span class="ticker-label">SMART CONTRACT</span>
                        </div>
                    </div>
                        </div>
                    </div>
                    </div>
    </section>
    
    <!-- Features Section -->
    <section class="features-section" id="features" data-scroll-reveal>
        <div class="section-header">
            <span class="section-tag">WHY CHOOSE US</span>
            <h2 class="section-title">Powered by Blockchain Technology</h2>
            <p class="section-description">
                Experience the most secure and profitable DGB mining platform with military-grade 
                blockchain protection and transparent smart contract operations.
                        </p>
                </div>

        <div class="features-grid">
            <div class="feature-card" data-scroll-reveal>
                <div class="feature-icon">
                    <i class="fas fa-shield-halved"></i>
            </div>
                <h3 class="feature-title">Blockchain Secured</h3>
                <p class="feature-description">
                    Your funds are protected by DigiByte's advanced blockchain technology with 
                    5 mining algorithms and real-time difficulty adjustment for maximum security.
                  </p>
			</div>
	    
            <div class="feature-card" data-scroll-reveal>
                <div class="feature-icon">
                    <i class="fas fa-file-contract"></i>
                        </div>
                <h3 class="feature-title">Smart Contracts</h3>
                <p class="feature-description">
                    All mining operations are governed by transparent smart contracts. 
                    No middlemen, no hidden fees - just pure blockchain automation.
                </p>
                    </div>
					
            <div class="feature-card" data-scroll-reveal>
                <div class="feature-icon">
                    <i class="fas fa-bolt"></i>
                        </div>
                <h3 class="feature-title">Lightning Fast</h3>
                <p class="feature-description">
                    DGB blocks occur every 15 seconds - 40x faster than Bitcoin. 
                    Experience instant mining outputs and rapid profit accumulation.
                </p>
                    </div>
					
            <div class="feature-card" data-scroll-reveal>
                <div class="feature-icon">
                    <i class="fas fa-chart-line"></i>
                        </div>
                <h3 class="feature-title">10% Daily Profit</h3>
                <p class="feature-description">
                    Earn approximately 10% daily returns on your mining investments. 
                    Watch your DGB grow in real-time with our live mining dashboard.
                </p>
                    </div>
					
            <div class="feature-card" data-scroll-reveal>
                <div class="feature-icon">
                    <i class="fas fa-wallet"></i>
                        </div>
                <h3 class="feature-title">Wallet-Based Access</h3>
                <p class="feature-description">
                    No registration forms or personal data required. Simply connect your 
                    DigiByte wallet address and start mining immediately.
                </p>
                    </div>
					
            <div class="feature-card" data-scroll-reveal>
                <div class="feature-icon">
                    <i class="fas fa-infinity"></i>
                        </div>
                <h3 class="feature-title">Decentralized Network</h3>
                <p class="feature-description">
                    Mine on a truly decentralized blockchain. No CEO, no ICO, no central control - 
                    just pure community-driven mining operations.
                </p>
                    </div>
                        </div>
    </section>
    
    <!-- Statistics Section -->
    <section class="stats-section" id="stats" data-scroll-reveal>
        <div class="stats-container">
            <div class="stat-item">
                <div class="stat-number" data-count="10">0</div>
                <div class="stat-text">Daily Profit %</div>
                        </div>
            <div class="stat-item">
                <div class="stat-number" data-count="100">0</div>
                <div class="stat-text">Mining Speed %</div>
                    </div>
            <div class="stat-item">
                <div class="stat-number" data-count="24">0</div>
                <div class="stat-text">Active Hours</div>
                </div>
            <div class="stat-item">
                <div class="stat-number" data-count="15">0</div>
                <div class="stat-text">Sec Block Time</div>
            </div>
			</div>
    </section>
    
    <!-- How It Works Section -->
    <section class="process-section" id="how-it-works" data-scroll-reveal>
        <div class="section-header">
            <span class="section-tag">SIMPLE PROCESS</span>
            <h2 class="section-title">How It Works</h2>
            <p class="section-description">
                Start mining DigiByte in just 3 simple steps. No complex setup, 
                no expensive hardware - just your wallet address.
            </p>
                </div>

        <div class="process-steps">
            <div class="step-card" data-scroll-reveal>
                <div class="step-number">1</div>
                <h3 class="step-title">Connect Wallet</h3>
                <p class="step-description">
                    Enter your DigiByte wallet address in the mining dashboard. 
                    No registration or KYC required.
                </p>
			</div>
	    
            <div class="step-card" data-scroll-reveal>
                <div class="step-number">2</div>
                <h3 class="step-title">Start Mining</h3>
                <p class="step-description">
                    Click "Start Mining" and watch your DGB accumulate in real-time 
                    as our blockchain infrastructure works for you.
                </p>
                    </div>
					
            <div class="step-card" data-scroll-reveal>
                <div class="step-number">3</div>
                <h3 class="step-title">Earn Profits</h3>
                <p class="step-description">
                    Receive approximately 10% daily profits directly to your wallet. 
                    Compound or withdraw anytime.
                </p>
                        </div>
                    </div>
    </section>
    
    <!-- Live Mining Activity Section -->
    <section class="activity-section" id="activity" data-scroll-reveal>
        <div class="section-header">
            <span class="section-tag">REAL-TIME</span>
            <h2 class="section-title">Live Mining Activity</h2>
            <p class="section-description">
                Watch real-time mining operations happening across our global network
            </p>
        </div>

        <div class="activity-feed">
            <div class="activity-item" data-scroll-reveal>
                <div class="activity-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="activity-content">
                    <div class="activity-wallet">DGxTk...7HnQ</div>
                    <div class="activity-action">Mined <span class="activity-amount">125.8 DGB</span></div>
                </div>
                <div class="activity-time">2 min ago</div>
            </div>

            <div class="activity-item" data-scroll-reveal>
                <div class="activity-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="activity-content">
                    <div class="activity-wallet">DRpNw...3KmP</div>
                    <div class="activity-action">Mined <span class="activity-amount">87.3 DGB</span></div>
                </div>
                <div class="activity-time">5 min ago</div>
            </div>

            <div class="activity-item" data-scroll-reveal>
                <div class="activity-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="activity-content">
                    <div class="activity-wallet">DFa9x...2VcL</div>
                    <div class="activity-action">Mined <span class="activity-amount">203.5 DGB</span></div>
                </div>
                <div class="activity-time">8 min ago</div>
            </div>

            <div class="activity-item" data-scroll-reveal>
                <div class="activity-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="activity-content">
                    <div class="activity-wallet">DHk2p...9WmN</div>
                    <div class="activity-action">Mined <span class="activity-amount">156.2 DGB</span></div>
                </div>
                <div class="activity-time">12 min ago</div>
            </div>

            <div class="activity-item" data-scroll-reveal>
                <div class="activity-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="activity-content">
                    <div class="activity-wallet">DSmQr...4TnH</div>
                    <div class="activity-action">Mined <span class="activity-amount">94.7 DGB</span></div>
                </div>
                <div class="activity-time">15 min ago</div>
            </div>
        </div>
    </section>

    <!-- Technical Specifications Section -->
    <section class="tech-specs-section" id="tech-specs" data-scroll-reveal>
        <div class="section-header">
            <span class="section-tag">TECHNICAL DETAILS</span>
            <h2 class="section-title">Advanced Mining Infrastructure</h2>
            <p class="section-description">
                Powered by cutting-edge blockchain technology and optimized mining algorithms
            </p>
        </div>

        <div class="specs-grid">
            <div class="spec-row" data-scroll-reveal>
                <div class="spec-label">Mining Algorithms</div>
                <div class="spec-value">Sha256, Scrypt, Skein, Qubit, Odocrypt</div>
            </div>

            <div class="spec-row" data-scroll-reveal>
                <div class="spec-label">Block Time</div>
                <div class="spec-value">15 Seconds (40x faster than BTC)</div>
            </div>

            <div class="spec-row" data-scroll-reveal>
                <div class="spec-label">Total Supply</div>
                <div class="spec-value">21 Billion DGB</div>
            </div>

            <div class="spec-row" data-scroll-reveal>
                <div class="spec-label">Block Reward</div>
                <div class="spec-value">Dynamic, adjusted every block</div>
            </div>

            <div class="spec-row" data-scroll-reveal>
                <div class="spec-label">Security Level</div>
                <div class="spec-value">Multi-Algorithm with DigiShield</div>
            </div>

            <div class="spec-row" data-scroll-reveal>
                <div class="spec-label">Smart Contracts</div>
                <div class="spec-value">Fully Automated & Transparent</div>
            </div>

            <div class="spec-row" data-scroll-reveal>
                <div class="spec-label">Minimum Investment</div>
                <div class="spec-value">0.001 DGB (No Limit)</div>
            </div>

            <div class="spec-row" data-scroll-reveal>
                <div class="spec-label">Withdrawal Method</div>
                <div class="spec-value">Direct to Wallet (Instant)</div>
            </div>
        </div>
    </section>

    <!-- Trust & Security Section -->
    <section class="trust-section" id="trust" data-scroll-reveal>
        <div class="section-header">
            <span class="section-tag">SECURITY FIRST</span>
            <h2 class="section-title">Bank-Level Security</h2>
            <p class="section-description">
                Your funds and data are protected by military-grade encryption and blockchain technology
            </p>
        </div>

        <div class="trust-grid">
            <div class="trust-item" data-scroll-reveal>
                <div class="trust-icon">
                    <i class="fas fa-lock"></i>
                </div>
                <div class="trust-metric">256-bit</div>
                <div class="trust-label">AES Encryption</div>
            </div>

            <div class="trust-item" data-scroll-reveal>
                <div class="trust-icon">
                    <i class="fas fa-server"></i>
                </div>
                <div class="trust-metric">99.9%</div>
                <div class="trust-label">Uptime SLA</div>
            </div>

            <div class="trust-item" data-scroll-reveal>
                <div class="trust-icon">
                    <i class="fas fa-shield-alt"></i>
                </div>
                <div class="trust-metric">5 Algorithms</div>
                <div class="trust-label">Multi-Shield</div>
            </div>

            <div class="trust-item" data-scroll-reveal>
                <div class="trust-icon">
                    <i class="fas fa-database"></i>
                </div>
                <div class="trust-metric">Cold Storage</div>
                <div class="trust-label">Wallet Protection</div>
            </div>
        </div>
    </section>

    <!-- Comparison Section -->
    <section class="comparison-section" id="comparison" data-scroll-reveal>
        <div class="section-header">
            <span class="section-tag">WHY DIGIBYTE</span>
            <h2 class="section-title">DigiByte vs Bitcoin Mining</h2>
            <p class="section-description">
                See how DigiByte outperforms traditional Bitcoin mining
            </p>
        </div>

        <div class="comparison-table">
            <div class="comparison-row comparison-header" data-scroll-reveal>
                <div class="comparison-cell">Feature</div>
                <div class="comparison-cell">DigiByte</div>
                <div class="comparison-cell">Bitcoin</div>
            </div>

            <div class="comparison-row" data-scroll-reveal>
                <div class="comparison-cell">Block Time</div>
                <div class="comparison-cell highlight">15 Seconds</div>
                <div class="comparison-cell dim">10 Minutes</div>
            </div>

            <div class="comparison-row" data-scroll-reveal>
                <div class="comparison-cell">Algorithms</div>
                <div class="comparison-cell highlight">5 (Multi-Shield)</div>
                <div class="comparison-cell dim">1 (SHA-256)</div>
            </div>

            <div class="comparison-row" data-scroll-reveal>
                <div class="comparison-cell">Transaction Speed</div>
                <div class="comparison-cell highlight">40x Faster</div>
                <div class="comparison-cell dim">Slower</div>
            </div>

            <div class="comparison-row" data-scroll-reveal>
                <div class="comparison-cell">Mining Difficulty</div>
                <div class="comparison-cell highlight">Lower Entry</div>
                <div class="comparison-cell dim">Very High</div>
            </div>

            <div class="comparison-row" data-scroll-reveal>
                <div class="comparison-cell">Decentralization</div>
                <div class="comparison-cell highlight">Superior</div>
                <div class="comparison-cell dim">Good</div>
            </div>

            <div class="comparison-row" data-scroll-reveal>
                <div class="comparison-cell">Energy Efficiency</div>
                <div class="comparison-cell highlight">Optimized</div>
                <div class="comparison-cell dim">High Power</div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section class="testimonials-section" id="testimonials" data-scroll-reveal>
        <div class="section-header">
            <span class="section-tag">SUCCESS STORIES</span>
            <h2 class="section-title">What Miners Are Saying</h2>
        </div>

        <div class="testimonials-grid">
            <div class="testimonial-card" data-scroll-reveal>
                <div class="testimonial-stars">
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                </div>
                <p class="testimonial-text">
                    "Been mining for 3 months and getting consistent 10% daily returns. The blockchain 
                    transparency gives me complete confidence. Best decision I made!"
                </p>
                <div class="testimonial-author">
                    <div class="author-avatar">JD</div>
                    <div class="author-info">
                        <div class="author-name">John D.</div>
                        <div class="author-wallet">DFpx...k3Nm</div>
                    </div>
                </div>
            </div>

            <div class="testimonial-card" data-scroll-reveal>
                <div class="testimonial-stars">
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                </div>
                <p class="testimonial-text">
                    "No KYC, no middlemen - just pure blockchain mining. I love the smart contract 
                    automation. Withdrawals are instant and profits are exactly as promised."
                </p>
                <div class="testimonial-author">
                    <div class="author-avatar">MK</div>
                    <div class="author-info">
                        <div class="author-name">Maria K.</div>
                        <div class="author-wallet">DHmc...2pQw</div>
                    </div>
                </div>
            </div>

            <div class="testimonial-card" data-scroll-reveal>
                <div class="testimonial-stars">
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                </div>
                <p class="testimonial-text">
                    "The 15-second block time makes DigiByte mining incredibly efficient. Watching 
                    my balance grow in real-time is amazing. Highly recommend this platform!"
                </p>
                <div class="testimonial-author">
                    <div class="author-avatar">RL</div>
                    <div class="author-info">
                        <div class="author-name">Robert L.</div>
                        <div class="author-wallet">DSv7...9TnX</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Blockchain Metrics Section -->
    <section class="metrics-section" id="metrics" data-scroll-reveal>
        <div class="section-header">
            <span class="section-tag">LIVE METRICS</span>
            <h2 class="section-title">Blockchain Network Status</h2>
        </div>

        <div class="metrics-grid">
            <div class="metric-box" data-scroll-reveal>
                <div class="metric-icon">⛏️</div>
                <div class="metric-value" id="totalMiners">15,847</div>
                <div class="metric-label">Active Miners</div>
            </div>

            <div class="metric-box" data-scroll-reveal>
                <div class="metric-icon">💰</div>
                <div class="metric-value" id="totalPaid">2.4M</div>
                <div class="metric-label">DGB Paid Out</div>
            </div>

            <div class="metric-box" data-scroll-reveal>
                <div class="metric-icon">⚡</div>
                <div class="metric-value" id="blockHeight">18,457,293</div>
                <div class="metric-label">Current Block</div>
            </div>

            <div class="metric-box" data-scroll-reveal>
                <div class="metric-icon">🌐</div>
                <div class="metric-value" id="networkHash">1.2 PH/s</div>
                <div class="metric-label">Network Hashrate</div>
                        </div>
                    </div>
    </section>
    
    <!-- FAQ Section -->
    <section class="faq-section" id="faq" data-scroll-reveal>
        <div class="section-header">
            <span class="section-tag">HAVE QUESTIONS?</span>
            <h2 class="section-title">Frequently Asked Questions</h2>
                    </div>
					
        <div class="faq-container">
            <div class="faq-item" data-scroll-reveal>
                <div class="faq-question">
                    How does the 10% daily profit work?
                    <i class="fas fa-chevron-down"></i>
                        </div>
                <div class="faq-answer">
                    Our advanced mining infrastructure combines cloud mining power with blockchain 
                    efficiency to generate approximately 10% daily returns. Your DGB accumulates 
                    in real-time and is secured by smart contracts on the DigiByte blockchain.
                        </div>
                    </div>
					
            <div class="faq-item" data-scroll-reveal>
                <div class="faq-question">
                    Is my investment secure?
                    <i class="fas fa-chevron-down"></i>
                        </div>
                <div class="faq-answer">
                    Absolutely! We use DigiByte's advanced blockchain technology with 5 mining 
                    algorithms and smart contract protection. Your funds are never held in 
                    centralized wallets - everything is managed by immutable smart contracts.
                    </div>
                </div>

            <div class="faq-item" data-scroll-reveal>
                <div class="faq-question">
                    What do I need to start mining?
                    <i class="fas fa-chevron-down"></i>
            </div>
                <div class="faq-answer">
                    Just your DigiByte wallet address! No expensive hardware, no technical knowledge 
                    required. Simply enter your wallet address and start mining immediately.
            </div>
			</div>
		
            <div class="faq-item" data-scroll-reveal>
                <div class="faq-question">
                    Can I withdraw my profits anytime?
                    <i class="fas fa-chevron-down"></i>
                        </div>
                <div class="faq-answer">
                    Yes! Your mined DGB is credited to your account in real-time. You can withdraw 
                    or compound your profits at any time with instant blockchain transactions.
                    </div>
                </div>

            <div class="faq-item" data-scroll-reveal>
                <div class="faq-question">
                    Why is DigiByte better than Bitcoin?
                    <i class="fas fa-chevron-down"></i>
            </div>
                <div class="faq-answer">
                    DigiByte blocks occur every 15 seconds (40x faster than Bitcoin), uses 5 mining 
                    algorithms for security, and has lower fees. It's more decentralized, faster, 
                    and more efficient for mining operations.
			</div>
                        </div>
                    </div>
    </section>
    
    <!-- Final CTA Section -->
    <section class="final-cta-section" id="start" data-scroll-reveal>
        <div class="cta-content">
            <h2 class="cta-title">Ready to Start Mining?</h2>
            <p class="cta-description">
                Join 15,000+ miners earning 10% daily profits with DigiByte blockchain technology
            </p>
            <div class="cta-stats">
                <div class="cta-stat">
                    <div class="cta-stat-value">2.4M+</div>
                    <div class="cta-stat-label">DGB Paid Out</div>
                </div>
                <div class="cta-stat-divider"></div>
                <div class="cta-stat">
                    <div class="cta-stat-value">15s</div>
                    <div class="cta-stat-label">Block Time</div>
                </div>
                <div class="cta-stat-divider"></div>
                <div class="cta-stat">
                    <div class="cta-stat-value">10%</div>
                    <div class="cta-stat-label">Daily Profit</div>
                </div>
            </div>
            <a href="#start-mining" class="cta-button">
                <span>CONNECT WALLET & START MINING</span>
                <i class="fas fa-arrow-right"></i>
            </a>
                    </div>
    </section>
    
    <!-- Footer -->
    <footer class="footer-section">
        <div class="footer-container">
            <div class="footer-grid">
                <div>
                    <div class="footer-brand">DGB MINING</div>
                    <p class="footer-description">
                        The world's most advanced DigiByte cloud mining platform. 
                        Secured by blockchain technology, powered by smart contracts, 
                        delivering 10% daily profits.
                    </p>
                    <div class="social-links">
                        <a href="https://t.me/DigiByteCoin" target="_blank" class="social-link">
                            <i class="fab fa-telegram-plane"></i>
                        </a>
                        <a href="https://x.com/DigiByteCoin" target="_blank" class="social-link">
                            <i class="fa-brands fa-x-twitter"></i>
                        </a>
                        <a href="https://dsc.gg/DigiByteDiscord" target="_blank" class="social-link">
                            <i class="fab fa-discord"></i>
                        </a>
                        <a href="https://github.com/DigiByte-Core/digibyte" target="_blank" class="social-link">
                            <i class="fab fa-github"></i>
                        </a>
                        </div>
                    </div>
					
                <div>
                    <h4 class="footer-title">Platform</h4>
                    <ul class="footer-links">
                        <li><a href="#features">Features</a></li>
                        <li><a href="#how-it-works">How It Works</a></li>
                        <li><a href="#stats">Statistics</a></li>
                        <li><a href="#faq">FAQ</a></li>
                    </ul>
                </div>

                <div>
                    <h4 class="footer-title">Resources</h4>
                    <ul class="footer-links">
                        <li><a href="https://github.com/DigiByte-Core/digibyte/wiki" target="_blank">DigiByte Wiki</a></li>
                        <li><a href="https://www.dgballiance.org" target="_blank">DGB Alliance</a></li>
                        <li><a href="https://dgbat.org" target="_blank">DGBAT</a></li>
                        <li><a href="https://digiexplorer.info" target="_blank">Explorer</a></li>
                    </ul>
                    </div>

                <div>
                    <h4 class="footer-title">Legal</h4>
                    <ul class="footer-links">
                        <li><a href="https://www.digibyte.org/docs/LegalDisclaimer.pdf" target="_blank">Disclaimer</a></li>
                        <li><a href="https://www.digibyte.org/docs/PrivacyPolicy.pdf" target="_blank">Privacy Policy</a></li>
                        <li><a href="https://opensource.org/licenses/mit-license.php" target="_blank">MIT License</a></li>
                    </ul>
                        </div>
                    </div>
                    
            <div class="footer-bottom">
                <p>&copy; <span id="currentYear"></span> DGB Mining Platform. All Rights Reserved. | 
                Powered by DigiByte Blockchain Technology</p>
                </div>
            </div>
    </footer>
    
    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/three.js/r128/three.min.js"></script>
    <script src="https://www.digibyte.org/js/jquery-3.5.1.min.js"></script>
    
    <script>
        // ==================== PERFORMANCE OPTIMIZATION UTILITIES ====================
        // Debounce function for optimizing scroll/resize events
        function debounce(func, wait = 16) {
            let timeout;
            return function executedFunction(...args) {
                const later = () => {
                    clearTimeout(timeout);
                    func(...args);
                };
                clearTimeout(timeout);
                timeout = setTimeout(later, wait);
            };
        }
        
        // Throttle function for high-frequency events
        function throttle(func, limit = 16) {
            let inThrottle;
            return function(...args) {
                if (!inThrottle) {
                    func.apply(this, args);
                    inThrottle = true;
                    setTimeout(() => inThrottle = false, limit);
                }
            };
        }
        
        // Lazy load animations - only animate when in viewport
        const observerOptions = {
            root: null,
            rootMargin: '0px',
            threshold: 0.1
        };
        
        const animationObserver = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('animate-in');
                }
            });
        }, observerOptions);
        
        // Observe all elements with data-animate attribute
        document.querySelectorAll('[data-animate]').forEach(el => {
            animationObserver.observe(el);
        });
        
        // Reduce motion for users who prefer it
        const prefersReducedMotion = window.matchMedia('(prefers-reduced-motion: reduce)').matches;
        if (prefersReducedMotion) {
            document.documentElement.style.setProperty('animation-duration', '0.01ms', 'important');
            document.documentElement.style.setProperty('transition-duration', '0.01ms', 'important');
        }
        
        // Current Year
        document.getElementById('currentYear').textContent = new Date().getFullYear();
        
        // Mobile Menu Toggle
        const mobileToggle = document.getElementById('mobileToggle');
        const navMenu = document.getElementById('navMenu');
        
        mobileToggle.addEventListener('click', () => {
            mobileToggle.classList.toggle('active');
            navMenu.classList.toggle('active');
        });
        
        // Close menu when clicking links
        document.querySelectorAll('.nav-menu a').forEach(link => {
            link.addEventListener('click', () => {
                mobileToggle.classList.remove('active');
                navMenu.classList.remove('active');
            });
        });
        
        // ==================== TERMINAL SIMULATION ====================
        const terminalCommands = [
            { type: 'command', text: 'sudo systemctl start dgb-miner.service' },
            { type: 'output', text: '[  OK  ] Started DigiByte Mining Service' },
            { type: 'command', text: 'dgb-miner --status' },
            { type: 'success', text: '✓ Mining Service: ACTIVE' },
            { type: 'success', text: '✓ Blockchain Connection: ESTABLISHED' },
            { type: 'success', text: '✓ Smart Contracts: LOADED' },
            { type: 'success', text: '✓ Hash Rate: 100% DH/S' },
            { type: 'command', text: 'watch -n 1 dgb-miner --monitor' },
            { type: 'output', text: 'Monitoring mining operations...' },
            { type: 'success', text: 'Block #18457291 - Validated' },
            { type: 'success', text: 'Block #18457292 - Validated' },
            { type: 'success', text: 'Block #18457293 - Validated' },
            { type: 'command', text: 'cat /proc/dgb/profit_rate' },
            { type: 'success', text: 'Daily Profit Rate: 10.00%' },
            { type: 'success', text: 'Mining Speed: 100%' },
            { type: 'success', text: 'Network Status: ONLINE' },
            { type: 'command', text: 'blockchain-verify --security' },
            { type: 'success', text: '✓ 5 Mining Algorithms Active' },
            { type: 'success', text: '✓ Smart Contracts Verified' },
            { type: 'success', text: '✓ Wallet Protection: ENABLED' },
            { type: 'command', text: 'dgb-miner --stats' },
            { type: 'output', text: 'Current Mining Statistics:' },
            { type: 'success', text: '├─ Blocks Mined: 1,247' },
            { type: 'success', text: '├─ Total Earnings: <?php echo e(5000 * $general->daily_earning); ?> DGB' },
            { type: 'success', text: '├─ Active Miners: 3,891' },
            { type: 'success', text: '└─ Network Hashrate: 847.3 TH/s' },
            { type: 'command', text: 'tail -f /var/log/dgb-miner.log' },
            { type: 'output', text: 'Streaming mining logs...' },
            { type: 'success', text: '[INFO] Transaction validated: 0x7f8a...' },
            { type: 'success', text: '[INFO] New block found: height 18457294' },
            { type: 'success', text: '[INFO] Profit credited: +0.00000847 DGB' }
        ];
        
        let commandIndex = 0;
        const terminalBody = document.getElementById('terminalBody');
        
        function addTerminalLine(command) {
            const line = document.createElement('div');
            line.className = 'terminal-line';
            
            if (command.type === 'command') {
                line.innerHTML = `<span class="terminal-prompt">dgb-miner@blockchain:~$</span> <span class="terminal-command">${command.text}</span>`;
            } else {
                line.innerHTML = `<span class="terminal-${command.type}">${command.text}</span>`;
            }
            
            terminalBody.appendChild(line);
            terminalBody.scrollTop = terminalBody.scrollHeight;
            
            commandIndex++;
            if (commandIndex < terminalCommands.length) {
                setTimeout(() => addTerminalLine(terminalCommands[commandIndex]), 
                    Math.random() * 1000 + 800);
            } else {
                // Loop back to start
                setTimeout(() => {
                    commandIndex = 0;
                    terminalBody.innerHTML = '';
                    addTerminalLine(terminalCommands[0]);
                }, 5000);
            }
        }
        
        // Start terminal simulation after page load
        setTimeout(() => {
            addTerminalLine(terminalCommands[0]);
        }, 3000);
        
        // Terminal Control Functions
        function minimizeTerminal() {
            document.getElementById('terminal').classList.toggle('minimized');
        }
        
        function maximizeTerminal() {
            const terminal = document.getElementById('terminal');
            if (terminal.style.width === '800px') {
                terminal.style.width = '500px';
                terminal.style.height = 'auto';
            } else {
                terminal.style.width = '800px';
                terminal.style.height = '500px';
            }
        }
        
        function closeTerminal() {
            const terminal = document.getElementById('terminal');
            terminal.style.animation = 'terminalSlideOut 0.5s ease-out forwards';
            setTimeout(() => {
                terminal.style.display = 'none';
            }, 500);
        }
        
        // Mining Code Rain Effect
        function createMiningCodeRain() {
            const matrixContainer = document.getElementById('matrixRain');
            
            // Mining-related code snippets
            const codeSnippets = [
                'validateBlock()',
                'mineDigiByte()',
                'hashAlgorithm()',
                'blockchain.add()',
                'smartContract()',
                'SHA256(hash)',
                'verifyTx()',
                '0xDGB...',
                'nonce++',
                'difficulty:18',
                'blockHeight++',
                'merkleRoot()',
                'utxo.verify()',
                'consensus()',
                'peer.sync()',
                'wallet.sign()',
                'tx.broadcast()',
                'mempool.add()',
                'pow.calculate()',
                'reward:10%',
                'hashrate:100%',
                'block.time:15s',
                'network.sync()',
                'chain.validate()',
                'address.gen()',
                'encrypt.aes256',
                'multisig.verify',
                'segwit.enabled',
                'fee.optimize()',
                'node.connect()',
                'api.mining()',
                'profit.calc()',
                'tx.confirm()',
                '{mining:true}',
                'async mine()',
                'await hash()',
                'if(valid)',
                'return block',
                'const dgb',
                'let profit',
                '=> mining',
                'crypto.hash',
                'block.reward'
            ];
            
            const columnCount = Math.floor(window.innerWidth / (window.innerWidth < 768 ? 120 : 100)); // Fewer columns on mobile
            
            for (let i = 0; i < columnCount; i++) {
                const column = document.createElement('div');
                column.className = 'matrix-column';
                column.style.left = `${i * (window.innerWidth < 768 ? 120 : 100) + Math.random() * 50}px`;
                column.style.animationDuration = `${Math.random() * (window.innerWidth < 768 ? 20 : 15) + 15}s`; // Slower on mobile
                column.style.animationDelay = `${Math.random() * 5}s`;
                
                let text = '';
                const lineCount = Math.floor(Math.random() * 10 + 20);
                for (let j = 0; j < lineCount; j++) {
                    text += codeSnippets[Math.floor(Math.random() * codeSnippets.length)] + '\n';
                }
                column.textContent = text;
                
                matrixContainer.appendChild(column);
            }
        }
        
        createMiningCodeRain();
        
        // Input Particles Effect
        function createInputParticles() {
            const inputParticles = document.getElementById('inputParticles');
            if (!inputParticles) return;
            
            setInterval(() => {
                const particle = document.createElement('div');
                particle.style.position = 'absolute';
                particle.style.width = '2px';
                particle.style.height = '2px';
                particle.style.background = 'var(--primary-cyan)';
                particle.style.borderRadius = '50%';
                particle.style.left = Math.random() * 100 + '%';
                particle.style.top = Math.random() * 100 + '%';
                particle.style.opacity = '0.6';
                particle.style.animation = 'particleFade 2s ease-out forwards';
                
                inputParticles.appendChild(particle);
                
                setTimeout(() => particle.remove(), 2000);
            }, 200);
        }
        
        // Add particle fade animation
        const style = document.createElement('style');
        style.textContent = `
            @keyframes particleFade {
                0% { transform: scale(0); opacity: 1; }
                100% { transform: scale(4); opacity: 0; }
            }
        `;
        document.head.appendChild(style);
        
        // Wallet input focus effects
        const walletInput = document.getElementById('walletInput');
        if (walletInput) {
            walletInput.addEventListener('focus', () => {
                createInputParticles();
            });
            
            walletInput.addEventListener('input', (e) => {
                if (e.target.value.length > 0) {
                    e.target.style.letterSpacing = '2px';
                } else {
                    e.target.style.letterSpacing = '1px';
                }
            });
        }
        
        // Sync Percentage Animation
        function animateSyncPercentage() {
            const syncElement = document.getElementById('syncPercent');
            if (!syncElement) return;
            
            setInterval(() => {
                const currentValue = parseFloat(syncElement.textContent);
                const newValue = (Math.random() * 1.5 + 98.5).toFixed(1);
                syncElement.textContent = newValue + '%';
            }, 3000);
        }
        
        animateSyncPercentage();
        
        // Progress Bar Animation
        function animateProgressBars() {
            const progressFills = document.querySelectorAll('.progress-fill');
            progressFills.forEach((fill, index) => {
                setInterval(() => {
                    const currentWidth = parseInt(fill.style.width);
                    const newWidth = Math.min(100, Math.max(75, currentWidth + (Math.random() * 6 - 3)));
                    fill.style.width = newWidth + '%';
                }, 2000 + index * 500);
            });
        }
        
        animateProgressBars();
        
        // Navbar Scroll Effect (Throttled for performance)
        const navbar = document.getElementById('navbar');
        const handleNavbarScroll = throttle(() => {
            if (window.scrollY > 100) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        }, 100);
        window.addEventListener('scroll', handleNavbarScroll, { passive: true });
        
        // Stars Background
        const starsCanvas = document.getElementById('stars');
        const starsCtx = starsCanvas.getContext('2d');
        starsCanvas.width = window.innerWidth;
        starsCanvas.height = window.innerHeight;
        
        const stars = [];
        const starCount = window.innerWidth < 768 ? 150 : 200; // More stars on mobile
        
        for (let i = 0; i < starCount; i++) {
            stars.push({
                x: Math.random() * starsCanvas.width,
                y: Math.random() * starsCanvas.height,
                radius: Math.random() * 2,
                opacity: Math.random(),
                speed: Math.random() * 0.5
            });
        }
        
        function animateStars() {
            starsCtx.clearRect(0, 0, starsCanvas.width, starsCanvas.height);
            stars.forEach(star => {
                starsCtx.beginPath();
                starsCtx.arc(star.x, star.y, star.radius, 0, Math.PI * 2);
                starsCtx.fillStyle = `rgba(0, 255, 255, ${star.opacity})`;
                starsCtx.fill();
                
                star.opacity += star.speed * 0.01;
                if (star.opacity > 1 || star.opacity < 0) {
                    star.speed *= -1;
                }
            });
            requestAnimationFrame(animateStars);
        }
        animateStars();
        
        // ==================== ADVANCED WEBGL 3D SCENE WITH SHADERS ====================
        if (typeof THREE !== 'undefined') {
            const heroCanvas = document.getElementById('heroParticles');
            const scene = new THREE.Scene();
            const camera = new THREE.PerspectiveCamera(75, window.innerWidth / window.innerHeight, 0.1, 1000);
            const renderer = new THREE.WebGLRenderer({ 
                canvas: heroCanvas, 
                alpha: true,
                antialias: true,
                powerPreference: "high-performance"
            });
            
            renderer.setSize(window.innerWidth, window.innerHeight);
            renderer.setPixelRatio(Math.min(window.devicePixelRatio, 2)); // Optimize for performance
            camera.position.z = 50;
            
            // Mouse tracking for interactive effects
            const mouse = { x: 0, y: 0 };
            const targetMouse = { x: 0, y: 0 };
            
            document.addEventListener('mousemove', (e) => {
                targetMouse.x = (e.clientX / window.innerWidth) * 2 - 1;
                targetMouse.y = -(e.clientY / window.innerHeight) * 2 + 1;
            });
            
            // Custom Shader Material for particles
            const vertexShader = `
                attribute float size;
                attribute vec3 customColor;
                varying vec3 vColor;
                uniform float time;
                uniform vec2 mousePos;
                
                void main() {
                    vColor = customColor;
                    vec3 pos = position;
                    
                    // Wave distortion
                    float wave = sin(pos.x * 0.1 + time) * cos(pos.y * 0.1 + time) * 3.0;
                    pos.z += wave;
                    
                    // Mouse interaction - warp effect
                    float dist = distance(pos.xy, mousePos * 50.0);
                    float influence = smoothstep(30.0, 0.0, dist);
                    pos.z += influence * 15.0;
                    pos.xy += mousePos * influence * 5.0;
                    
                    vec4 mvPosition = modelViewMatrix * vec4(pos, 1.0);
                    gl_PointSize = size * (300.0 / -mvPosition.z);
                    gl_Position = projectionMatrix * mvPosition;
                }
            `;
            
            const fragmentShader = `
                varying vec3 vColor;
                uniform float time;
                
                void main() {
                    // Circular particle shape
                    vec2 center = gl_PointCoord - vec2(0.5);
                    float dist = length(center);
                    if (dist > 0.5) discard;
                    
                    // Pulsing glow effect
                    float alpha = 1.0 - dist * 2.0;
                    alpha *= (0.7 + 0.3 * sin(time * 2.0));
                    
                    gl_FragColor = vec4(vColor, alpha);
                }
            `;
            
            // Create particle system (responsive particle count)
            const particleCount = window.innerWidth < 768 ? 400 : 800; // Fewer particles on mobile for performance
            const particles = new THREE.BufferGeometry();
            const positions = new Float32Array(particleCount * 3);
            const colors = new Float32Array(particleCount * 3);
            const sizes = new Float32Array(particleCount);
            
            for (let i = 0; i < particleCount; i++) {
                const i3 = i * 3;
                positions[i3] = (Math.random() - 0.5) * 200;
                positions[i3 + 1] = (Math.random() - 0.5) * 200;
                positions[i3 + 2] = (Math.random() - 0.5) * 100;
                
                // Darker cyan/blue colors
                const colorChoice = Math.random();
                if (colorChoice < 0.4) {
                    colors[i3] = 0.0;
                    colors[i3 + 1] = 0.6;
                    colors[i3 + 2] = 0.6;
                } else if (colorChoice < 0.7) {
                    colors[i3] = 0.0;
                    colors[i3 + 1] = 0.4;
                    colors[i3 + 2] = 0.8;
                } else {
                    colors[i3] = 0.4;
                    colors[i3 + 1] = 0.1;
                    colors[i3 + 2] = 0.7;
                }
                
                sizes[i] = Math.random() * 3 + 1;
            }
            
            particles.setAttribute('position', new THREE.BufferAttribute(positions, 3));
            particles.setAttribute('customColor', new THREE.BufferAttribute(colors, 3));
            particles.setAttribute('size', new THREE.BufferAttribute(sizes, 1));
            
            const shaderMaterial = new THREE.ShaderMaterial({
                uniforms: {
                    time: { value: 0 },
                    mousePos: { value: new THREE.Vector2(0, 0) }
                },
                vertexShader,
                fragmentShader,
                transparent: true,
                blending: THREE.AdditiveBlending,
                depthWrite: false
            });
            
            const particleSystem = new THREE.Points(particles, shaderMaterial);
            scene.add(particleSystem);
            
            // Add 3D geometric shapes with shaders (responsive sizing)
            const isMobile = window.innerWidth < 768;
            const torusSize = isMobile ? 10 : 15;
            const sphereSize = isMobile ? 7 : 10;
            const shapeOpacity = isMobile ? 0.12 : 0.15;
            
            const torusGeometry = new THREE.TorusGeometry(torusSize, 2, 16, 100);
            const torusMaterial = new THREE.MeshBasicMaterial({
                color: 0x009999,
                wireframe: true,
                transparent: true,
                opacity: shapeOpacity
            });
            const torus = new THREE.Mesh(torusGeometry, torusMaterial);
            torus.position.x = isMobile ? 20 : 30;
            scene.add(torus);
            
            const sphereGeometry = new THREE.IcosahedronGeometry(sphereSize, 1);
            const sphereMaterial = new THREE.MeshBasicMaterial({
                color: 0x6a1bb2,
                wireframe: true,
                transparent: true,
                opacity: shapeOpacity
            });
            const sphere = new THREE.Mesh(sphereGeometry, sphereMaterial);
            sphere.position.x = isMobile ? -20 : -30;
            sphere.position.y = -10;
            scene.add(sphere);
            
            // Performance optimizations (adaptive FPS for mobile)
            let lastTime = 0;
            const targetFPS = isMobile ? 45 : 60; // Lower FPS on mobile for battery life
            const frameInterval = 1000 / targetFPS;
            
            function animateParticles(currentTime) {
                requestAnimationFrame(animateParticles);
                
                const deltaTime = currentTime - lastTime;
                if (deltaTime < frameInterval) return;
                lastTime = currentTime - (deltaTime % frameInterval);
                
                // Smooth mouse movement
                mouse.x += (targetMouse.x - mouse.x) * 0.05;
                mouse.y += (targetMouse.y - mouse.y) * 0.05;
                
                // Update shader uniforms
                shaderMaterial.uniforms.time.value = currentTime * 0.001;
                shaderMaterial.uniforms.mousePos.value.set(mouse.x, mouse.y);
                
                // Rotate particle system
                particleSystem.rotation.y += 0.001;
                particleSystem.rotation.x += 0.0003;
                
                // Rotate 3D shapes
                torus.rotation.x += 0.01;
                torus.rotation.y += 0.005;
                sphere.rotation.x -= 0.008;
                sphere.rotation.y += 0.01;
                
                // Scroll-based warp effect
                const scrollProgress = window.pageYOffset / (document.documentElement.scrollHeight - window.innerHeight);
                camera.position.z = 50 + scrollProgress * 30;
                camera.rotation.x = scrollProgress * 0.3;
                
                renderer.render(scene, camera);
            }
            animateParticles(0);
            
            // Interactive hover effects on dashboard cards
            const miningDashboard = document.querySelector('.mining-dashboard');
            if (miningDashboard) {
                miningDashboard.addEventListener('mousemove', (e) => {
                    const rect = miningDashboard.getBoundingClientRect();
                    const x = ((e.clientX - rect.left) / rect.width) * 2 - 1;
                    const y = -((e.clientY - rect.top) / rect.height) * 2 + 1;
                    
                    miningDashboard.style.transform = `perspective(1000px) rotateY(${x * 5}deg) rotateX(${y * 5}deg) translateZ(10px)`;
                });
                
                miningDashboard.addEventListener('mouseleave', () => {
                    miningDashboard.style.transform = 'perspective(1000px) rotateY(0deg) rotateX(0deg) translateZ(0px)';
                });
            }
            
            // Interactive warp effects on stat boxes
            const statBoxes = document.querySelectorAll('.stat-box');
            statBoxes.forEach(box => {
                box.addEventListener('mousemove', (e) => {
                    const rect = box.getBoundingClientRect();
                    const x = ((e.clientX - rect.left) / rect.width) * 2 - 1;
                    const y = -((e.clientY - rect.top) / rect.height) * 2 + 1;
                    
                    box.style.transform = `perspective(500px) rotateY(${x * 10}deg) rotateX(${y * 10}deg) translateZ(15px) scale(1.05)`;
                });
                
                box.addEventListener('mouseleave', () => {
                    box.style.transform = 'perspective(500px) rotateY(0deg) rotateX(0deg) translateZ(0px) scale(1)';
                });
            });
        }
        
        // Resize Handler (Debounced for performance)
        const handleResize = debounce(() => {
            starsCanvas.width = window.innerWidth;
            starsCanvas.height = window.innerHeight;
            
            // Update WebGL scene on all devices
            if (typeof camera !== 'undefined' && typeof renderer !== 'undefined') {
                camera.aspect = window.innerWidth / window.innerHeight;
                camera.updateProjectionMatrix();
                renderer.setSize(window.innerWidth, window.innerHeight);
                renderer.setPixelRatio(Math.min(window.devicePixelRatio, 2));
            }
        }, 250);
        
        window.addEventListener('resize', handleResize, { passive: true });
        
        // Scroll Reveal (Optimized with Intersection Observer)
        const revealElements = document.querySelectorAll('[data-scroll-reveal]');
        if (revealElements.length > 0) {
            const revealObserver = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('revealed');
                        revealObserver.unobserve(entry.target); // Stop observing after reveal
                    }
                });
            }, { threshold: 0.1, rootMargin: '-100px' });
            
            revealElements.forEach(el => revealObserver.observe(el));
        }
        
        // Counter Animation (Optimized with Intersection Observer)
        const counters = document.querySelectorAll('[data-count]');
        if (counters.length > 0) {
            const counterObserver = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const counter = entry.target;
                    const target = parseInt(counter.getAttribute('data-count'));
                    let current = 0;
                    const increment = target / 60;
                    
                    const updateCounter = () => {
                        current += increment;
                        if (current < target) {
                            counter.textContent = Math.ceil(current);
                            requestAnimationFrame(updateCounter);
                        } else {
                            counter.textContent = target;
                        }
                    };
                    updateCounter();
                        counterObserver.unobserve(counter); // Animate only once
                }
            });
            }, { threshold: 0.5 });
            
            counters.forEach(counter => counterObserver.observe(counter));
        }
        
        // Smooth Scroll
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({ behavior: 'smooth', block: 'start' });
                }
            });
        });
        
        // ==================== FAQ ACCORDION FUNCTIONALITY ====================
        const faqItems = document.querySelectorAll('.faq-item');
        
        faqItems.forEach(item => {
            const question = item.querySelector('.faq-question');
            const answer = item.querySelector('.faq-answer');
            const icon = question.querySelector('i');
            
            if (question && answer) {
                question.addEventListener('click', () => {
                    // Close all other FAQ items
                    faqItems.forEach(otherItem => {
                        if (otherItem !== item && otherItem.classList.contains('active')) {
                            otherItem.classList.remove('active');
                            const otherAnswer = otherItem.querySelector('.faq-answer');
                            const otherIcon = otherItem.querySelector('.faq-question i');
                            if (otherAnswer) otherAnswer.style.maxHeight = null;
                            if (otherIcon) otherIcon.style.transform = '';
                        }
                    });
                    
                    // Toggle current item
                    item.classList.toggle('active');
                    
                    if (item.classList.contains('active')) {
                        // Open
                        answer.style.maxHeight = answer.scrollHeight + 'px';
                        if (icon) icon.style.transform = 'rotate(180deg)';
                    } else {
                        // Close
                        answer.style.maxHeight = null;
                        if (icon) icon.style.transform = '';
                    }
                });
            }
        });
        
        // ==================== PAGE LOAD OPTIMIZATION ====================
        // Add loaded class to body when page is fully loaded
        window.addEventListener('load', () => {
            document.body.classList.add('page-loaded');
            
            // Log performance metrics (development only)
            if (window.performance && console.log) {
                const perfData = window.performance.timing;
                const pageLoadTime = perfData.loadEventEnd - perfData.navigationStart;
                console.log(`⚡ Page loaded in ${pageLoadTime}ms`);
                
                // Mark first contentful paint
                if (performance.getEntriesByType) {
                    const paintMetrics = performance.getEntriesByType('paint');
                    paintMetrics.forEach(metric => {
                        console.log(`🎨 ${metric.name}: ${metric.startTime.toFixed(2)}ms`);
                    });
                }
            }
        });
        
        // Preload critical assets on hover (predictive loading)
        document.querySelectorAll('a[href]').forEach(link => {
            link.addEventListener('mouseenter', function() {
                const href = this.getAttribute('href');
                if (href && !href.startsWith('#')) {
                    const linkEl = document.createElement('link');
                    linkEl.rel = 'prefetch';
                    linkEl.href = href;
                    document.head.appendChild(linkEl);
                }
            }, { once: true });
        });
        
        // Cleanup and memory management
        window.addEventListener('beforeunload', () => {
            // Clean up Three.js resources if they exist
            if (typeof scene !== 'undefined' && scene.children) {
                scene.children.forEach(child => {
                    if (child.geometry) child.geometry.dispose();
                    if (child.material) {
                        if (Array.isArray(child.material)) {
                            child.material.forEach(mat => mat.dispose());
                        } else {
                            child.material.dispose();
                        }
                    }
                });
            }
            if (typeof renderer !== 'undefined') {
                renderer.dispose();
            }
        });
        
        // ==================== LIVE METRICS ANIMATION ====================
        // Animate metrics incrementing
        function animateMetrics() {
            const totalMinersEl = document.getElementById('totalMiners');
            const totalPaidEl = document.getElementById('totalPaid');
            const blockHeightEl = document.getElementById('blockHeight');
            
            if (totalMinersEl) {
                setInterval(() => {
                    const current = parseInt(totalMinersEl.textContent.replace(/,/g, ''));
                    const change = Math.floor(Math.random() * 10) - 3; // -3 to +6
                    const newValue = Math.max(15000, current + change);
                    totalMinersEl.textContent = newValue.toLocaleString();
                }, 5000);
            }
            
            if (totalPaidEl) {
                setInterval(() => {
                    const current = parseFloat(totalPaidEl.textContent.replace('M', ''));
                    const newValue = (current + Math.random() * 0.01).toFixed(1);
                    totalPaidEl.textContent = newValue + 'M';
                }, 8000);
            }
            
            if (blockHeightEl) {
                setInterval(() => {
                    const current = parseInt(blockHeightEl.textContent.replace(/,/g, ''));
                    blockHeightEl.textContent = (current + 1).toLocaleString();
                }, 15000); // Every 15 seconds (DGB block time)
            }
        }
        
        animateMetrics();
        
        // ==================== LIVE ACTIVITY FEED SIMULATION ====================
        const activityFeed = document.querySelector('.activity-feed');
        if (activityFeed) {
            const walletPrefixes = ['DGxTk', 'DRpNw', 'DFa9x', 'DHk2p', 'DSmQr', 'DTnMx', 'DPq7w', 'DLmKn'];
            const walletSuffixes = ['7HnQ', '3KmP', '2VcL', '9WmN', '4TnH', '8RpQ', '5LmN', '6TkP'];
            
            function addNewActivity() {
                const randomWallet = walletPrefixes[Math.floor(Math.random() * walletPrefixes.length)] + 
                                    '...' + 
                                    walletSuffixes[Math.floor(Math.random() * walletSuffixes.length)];
                const randomAmount = (Math.random() * 200 + 50).toFixed(1);
                
                // Remove last item
                const items = activityFeed.querySelectorAll('.activity-item');
                if (items.length >= 5) {
                    items[items.length - 1].style.opacity = '0';
                    setTimeout(() => items[items.length - 1].remove(), 300);
                }
                
                // Add new item at top
                const newItem = document.createElement('div');
                newItem.className = 'activity-item';
                newItem.innerHTML = `
                    <div class="activity-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="activity-content">
                        <div class="activity-wallet">${randomWallet}</div>
                        <div class="activity-action">Mined <span class="activity-amount">${randomAmount} DGB</span></div>
                    </div>
                    <div class="activity-time">Just now</div>
                `;
                newItem.style.opacity = '0';
                activityFeed.insertBefore(newItem, activityFeed.firstChild);
                
                setTimeout(() => newItem.style.opacity = '1', 100);
                
                // Update timestamps
                setTimeout(() => {
                    const timeElements = activityFeed.querySelectorAll('.activity-time');
                    timeElements.forEach((el, index) => {
                        if (index === 0) el.textContent = 'Just now';
                        else if (index === 1) el.textContent = '2 min ago';
                        else if (index === 2) el.textContent = '5 min ago';
                        else if (index === 3) el.textContent = '8 min ago';
                        else if (index === 4) el.textContent = '12 min ago';
                    });
                }, 500);
            }
            
            // Add new activity every 20-30 seconds
            setInterval(addNewActivity, Math.random() * 10000 + 20000);
        }
        
        console.log('%c🚀 DigiByte Cloud Mining Platform', 'color: #00ffff; font-size: 20px; font-weight: bold;');
        console.log('%c⚡ Powered by WebGL Shaders & Advanced 3D Graphics', 'color: #00cccc; font-size: 14px;');
        console.log('%c🔒 Secured by Blockchain Technology', 'color: #6a1bb2; font-size: 14px;');
    </script>
    
    <?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            // Mining Counter
            let dailyProfit = $('#dailyProfit').text();
            let dailyProfitInSeconds = dailyProfit / 864000;
            let minedAmount = 0;
            
            setInterval(function() {
                minedAmount += dailyProfitInSeconds;
                $('#mined').text(minedAmount.toFixed(8));
            }, 100);
            
            // Login Form
            $('#loginForm').on('submit', function(e) {
                e.preventDefault();
                var data = $(this).serialize();
                var wallet = $(this).find('[name=wallet]').val();
                
                if (!wallet) {
                    alert('Wallet address is required');
                    return;
                }

                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('account.login')); ?>",
                    data: data,
                    dataType: "json",
                    success: function(response) {
                        if (response.error) {
                            alert(response.error);
                        } else {
                            alert(response.success);
                            setTimeout(function() {
                                window.location.href = "<?php echo e(route('account.home')); ?>";
                            }, 1000);
                        }
                    },
                    error: function(response) {
                        alert("Session error. Page will reload.");
                        setTimeout(() => {
                            location.reload();
                        }, 2000);
                    }
                });
            });
        })(jQuery);
    </script>
    <?php $__env->stopPush(); ?>
</body>
</html>
<?php /**PATH /home/stellar/public_html/core/resources/views/templates/basic/sections/banner.blade.php ENDPATH**/ ?>