
<?php $__env->startSection('content'); ?>

<style>
    :root {
        --dgb-cyan: #00cccc;
        --dgb-blue: #0066cc;
        --dgb-purple: #6a1bb2;
        --dgb-pink: #cc0055;
        --dgb-green: #00cc00;
    }

    /* ==================== ANIMATED BACKGROUND LAYERS ==================== */
    .dashboard-cosmic-bg {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -5;
        background: 
            radial-gradient(ellipse at 10% 20%, rgba(0, 150, 150, 0.08) 0%, transparent 50%),
            radial-gradient(ellipse at 90% 80%, rgba(80, 25, 130, 0.08) 0%, transparent 50%),
            radial-gradient(ellipse at 50% 50%, rgba(0, 70, 140, 0.06) 0%, transparent 50%),
            linear-gradient(135deg, #000000 0%, #050508 25%, #000000 50%, #0a0a0f 75%, #000000 100%);
        background-size: 400% 400%, 400% 400%, 300% 300%, 400% 400%;
        animation: megaGradient 20s ease infinite;
        pointer-events: none;
    }
    
    @keyframes megaGradient {
        0%, 100% { 
            background-position: 0% 50%, 100% 50%, 50% 50%, 0% 50%; 
            filter: hue-rotate(0deg);
        }
        25% { 
            background-position: 100% 50%, 0% 50%, 25% 75%, 50% 100%;
            filter: hue-rotate(10deg);
        }
        50% { 
            background-position: 100% 100%, 0% 0%, 75% 25%, 100% 50%;
            filter: hue-rotate(20deg);
        }
        75% { 
            background-position: 0% 100%, 100% 0%, 50% 50%, 50% 0%;
            filter: hue-rotate(10deg);
        }
    }
    
    .dashboard-gradient-orbs {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -4;
        overflow: hidden;
        pointer-events: none;
    }
    
    .dashboard-orb {
        position: absolute;
        border-radius: 50%;
        filter: blur(80px);
        opacity: 0.3;
        animation: orbFloat 15s ease-in-out infinite;
    }
    
    .dashboard-orb-1 {
        width: 400px;
        height: 400px;
        background: radial-gradient(circle, rgba(0, 150, 150, 0.2), transparent);
        top: -200px;
        left: -200px;
        animation-delay: 0s;
    }
    
    .dashboard-orb-2 {
        width: 500px;
        height: 500px;
        background: radial-gradient(circle, rgba(80, 25, 130, 0.15), transparent);
        bottom: -250px;
        right: -250px;
        animation-delay: 5s;
    }
    
    .dashboard-orb-3 {
        width: 350px;
        height: 350px;
        background: radial-gradient(circle, rgba(0, 70, 140, 0.18), transparent);
        top: 50%;
        left: 50%;
        animation-delay: 10s;
    }
    
    .dashboard-orb-4 {
        width: 300px;
        height: 300px;
        background: radial-gradient(circle, rgba(150, 0, 65, 0.15), transparent);
        top: 30%;
        right: 10%;
        animation-delay: 7s;
    }
    
    @keyframes orbFloat {
        0%, 100% { 
            transform: translate(0, 0) scale(1);
        }
        25% { 
            transform: translate(100px, -100px) scale(1.1);
        }
        50% { 
            transform: translate(-50px, 100px) scale(0.9);
        }
        75% { 
            transform: translate(-100px, -50px) scale(1.05);
        }
    }
    
    .dashboard-cyber-grid {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -3;
        background-image: 
            linear-gradient(rgba(0, 150, 150, 0.015) 1px, transparent 1px),
            linear-gradient(90deg, rgba(0, 150, 150, 0.015) 1px, transparent 1px);
        background-size: 50px 50px;
        animation: gridScroll 20s linear infinite;
        pointer-events: none;
    }
    
    @keyframes gridScroll {
        0% { transform: perspective(500px) rotateX(60deg) translateY(0); }
        100% { transform: perspective(500px) rotateX(60deg) translateY(50px); }
    }
    
    .dashboard-stars-layer {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -2;
        pointer-events: none;
    }
    
    .dashboard-matrix-rain {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -1;
        pointer-events: none;
        opacity: 0.12;
    }
    
    .dashboard-matrix-column {
        position: absolute;
        top: -100%;
        font-family: 'Courier New', monospace;
        font-size: 11px;
        color: #0f0;
        text-shadow: 0 0 8px #0f0;
        animation: matrixFall linear infinite;
        white-space: pre;
        line-height: 1.4;
    }
    
    @keyframes matrixFall {
        to { top: 100%; }
    }

    .dgb-page-container {
        position: relative;
        padding: 20px;
        border-radius: 12px;
        background: linear-gradient(135deg, rgba(0, 0, 0, 0.85) 0%, rgba(10, 10, 20, 0.85) 100%);
    }

    .dgb-deposit-card {
        background: rgba(0, 0, 0, 0.2);
        border: 1px solid rgba(0, 204, 204, 0.15);
        border-radius: 10px;
        padding: 25px;
        margin-bottom: 30px;
    }

    .dgb-card-title {
        font-size: 16px;
        font-weight: 500;
        color: rgba(255, 255, 255, 0.9);
        margin-bottom: 20px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .dgb-deposit-address {
        padding: 18px;
        background: rgba(0, 204, 204, 0.08);
        border: 2px solid rgba(0, 204, 204, 0.3);
        border-radius: 10px;
        color: var(--dgb-cyan, #00cccc);
        font-family: 'Courier New', monospace;
        font-size: 14px;
        word-break: break-all;
        margin-bottom: 15px;
        text-align: center;
        font-weight: 600;
        letter-spacing: 1px;
        animation: addressReveal 0.6s ease-out;
        box-shadow: 0 0 20px rgba(0, 204, 204, 0.2);
    }

    @keyframes addressReveal {
        from { 
            opacity: 0; 
            transform: scale(0.9);
        }
        to { 
            opacity: 1; 
            transform: scale(1);
        }
    }

    .dgb-generate-btn,
    .dgb-copy-address-btn {
        width: 100%;
        padding: 16px 24px;
        background: rgba(0, 204, 204, 0.15);
        border: 2px solid rgba(0, 204, 204, 0.4);
        border-radius: 10px;
        color: var(--dgb-cyan, #00cccc);
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
        cursor: pointer;
        transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        font-size: 14px;
        position: relative;
        overflow: hidden;
    }

    .dgb-generate-btn::before,
    .dgb-copy-address-btn::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 0;
        height: 0;
        background: rgba(0, 255, 255, 0.3);
        border-radius: 50%;
        transform: translate(-50%, -50%);
        transition: all 0.5s ease;
    }

    .dgb-generate-btn:hover,
    .dgb-copy-address-btn:hover {
        background: rgba(0, 204, 204, 0.3);
        border-color: rgba(0, 255, 255, 0.8);
        transform: translateY(-3px);
        box-shadow: 
            0 0 30px rgba(0, 255, 255, 0.4),
            inset 0 0 20px rgba(0, 255, 255, 0.1);
    }

    .dgb-generate-btn:hover::before,
    .dgb-copy-address-btn:hover::before {
        width: 300px;
        height: 300px;
    }

    .dgb-generate-btn:active,
    .dgb-copy-address-btn:active {
        transform: translateY(-1px) scale(0.98);
    }

    .dgb-generate-btn:disabled {
        opacity: 0.4;
        cursor: not-allowed;
        transform: none;
    }

    .dgb-generate-btn:disabled:hover {
        box-shadow: none;
        border-color: rgba(0, 204, 204, 0.4);
    }

    .dgb-info-footer {
        background: rgba(0, 204, 204, 0.05);
        border: 1px solid rgba(0, 204, 204, 0.1);
        border-radius: 8px;
        padding: 15px;
        margin-top: 20px;
    }

    .dgb-info-text {
        font-size: 12px;
        color: rgba(255, 255, 255, 0.7);
        line-height: 1.6;
        margin: 0;
    }

    .dgb-info-text strong {
        color: var(--dgb-cyan, #00cccc);
    }

    .dgb-loader {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
        padding: 20px;
        color: var(--dgb-cyan, #00cccc);
        font-size: 14px;
    }

    .dgb-loader i {
        font-size: 20px;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .dgb-error-message {
        background: rgba(220, 53, 69, 0.1);
        border: 1px solid rgba(220, 53, 69, 0.3);
        border-radius: 8px;
        padding: 12px;
        color: rgba(255, 70, 85, 0.9);
        font-size: 13px;
        margin-bottom: 15px;
    }

    .dgb-success-message {
        background: rgba(0, 204, 0, 0.1);
        border: 1px solid rgba(0, 204, 0, 0.3);
        border-radius: 8px;
        padding: 12px;
        color: rgba(0, 255, 0, 0.9);
        font-size: 13px;
        margin-top: 10px;
    }

    .dgb-section-title {
        font-size: 18px;
        font-weight: 500;
        color: rgba(255, 255, 255, 0.9);
        margin-bottom: 20px;
        margin-top: 30px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .dgb-table-container {
        background: rgba(0, 0, 0, 0.2);
        border: 1px solid rgba(0, 204, 204, 0.15);
        border-radius: 10px;
        padding: 20px;
        overflow-x: auto;
    }

    .dgb-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
    }

    .dgb-table thead th {
        background: rgba(0, 204, 204, 0.1);
        color: var(--dgb-cyan, #00cccc);
        font-size: 12px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 1px;
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid rgba(0, 204, 204, 0.2);
    }

    .dgb-table tbody tr {
        transition: all 0.3s ease;
        border-bottom: 1px solid rgba(0, 204, 204, 0.05);
    }

    .dgb-table tbody tr:hover {
        background: rgba(0, 204, 204, 0.05);
    }

    .dgb-table tbody td {
        padding: 15px;
        color: rgba(255, 255, 255, 0.8);
        font-size: 13px;
    }

    .dgb-table tbody tr:last-child {
        border-bottom: none;
    }

    .dgb-table-empty {
        text-align: center;
        padding: 40px 20px;
        color: rgba(255, 255, 255, 0.5);
        font-size: 14px;
    }

    @media (max-width: 768px) {
        .dgb-page-container {
            padding: 15px;
        }

        .dgb-deposit-card {
            padding: 20px;
        }

        .dgb-card-title {
            font-size: 14px;
        }

        .dgb-deposit-address {
            font-size: 12px;
            padding: 12px;
        }

        .dgb-table-container {
            padding: 15px;
        }

        .dgb-table {
            font-size: 11px;
        }

        .dgb-table thead th,
        .dgb-table tbody td {
            padding: 10px 8px;
            font-size: 11px;
        }
    }

    @media (max-width: 480px) {
        .dgb-page-container {
            padding: 10px;
        }

        .dgb-deposit-card {
            padding: 15px;
        }

        .dgb-generate-btn,
        .dgb-copy-address-btn {
            padding: 12px 18px;
            font-size: 12px;
        }

        .dgb-info-text {
            font-size: 11px;
        }
    }
</style>

<!-- Animated Background Layers -->
<div class="dashboard-cosmic-bg"></div>

<div class="dashboard-gradient-orbs">
    <div class="dashboard-orb dashboard-orb-1"></div>
    <div class="dashboard-orb dashboard-orb-2"></div>
    <div class="dashboard-orb dashboard-orb-3"></div>
    <div class="dashboard-orb dashboard-orb-4"></div>
</div>

<div class="dashboard-cyber-grid"></div>
<canvas class="dashboard-stars-layer" id="dashboardStars"></canvas>

<!-- Matrix Rain Effect -->
<div class="dashboard-matrix-rain" id="dashboardMatrixRain"></div>

<div class="dgb-page-container">
    <!-- Quick Stats -->
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(140px, 1fr)); gap: 12px; margin-bottom: 25px;">
        <div style="background: rgba(0, 0, 0, 0.2); border: 1px solid rgba(0, 204, 204, 0.15); border-radius: 8px; padding: 15px; text-align: center;">
            <div style="font-size: 11px; color: rgba(255, 255, 255, 0.5); margin-bottom: 6px; text-transform: uppercase;">Min Deposit</div>
            <div style="font-size: 18px; color: var(--dgb-cyan, #00cccc); font-family: 'Orbitron', monospace; font-weight: 600;"><?php echo e($gateway->minimum_deposit); ?></div>
        </div>
        <div style="background: rgba(0, 0, 0, 0.2); border: 1px solid rgba(0, 204, 204, 0.15); border-radius: 8px; padding: 15px; text-align: center;">
            <div style="font-size: 11px; color: rgba(255, 255, 255, 0.5); margin-bottom: 6px; text-transform: uppercase;">1 DH/S Cost</div>
            <div style="font-size: 18px; color: var(--dgb-cyan, #00cccc); font-family: 'Orbitron', monospace; font-weight: 600;"><?php echo e($general->dhs_price); ?></div>
        </div>
        <div style="background: rgba(0, 0, 0, 0.2); border: 1px solid rgba(0, 204, 204, 0.15); border-radius: 8px; padding: 15px; text-align: center;">
            <div style="font-size: 11px; color: rgba(255, 255, 255, 0.5); margin-bottom: 6px; text-transform: uppercase;">Daily Earning</div>
            <div style="font-size: 18px; color: var(--dgb-green, #00cc00); font-family: 'Orbitron', monospace; font-weight: 600;"><?php echo e($general->daily_earning); ?></div>
        </div>
    </div>

    <!-- Deposit Card -->
    <div class="dgb-deposit-card">
        <h5 class="dgb-card-title">
            <i class="fas fa-wallet"></i> <?php echo app('translator')->get('Generate Deposit Address'); ?>
        </h5>
        
        <div id="waitingLoader" class="dgb-loader d-none">
            <i class="las la-spinner"></i>
            <span><?php echo app('translator')->get('Generating address...'); ?></span>
        </div>
        
        <h4 class="dgb-error-message d-none error-message"></h4>
        
        <h4 class="dgb-deposit-address d-none deposit-address"></h4>
        
        <button class="dgb-copy-address-btn d-none" id="copyBtn" type="button">
            <i class="fa fa-copy"></i> <?php echo app('translator')->get('Copy Address'); ?>
        </button>
        
        <span class="dgb-success-message d-none copy-success-message">
            <i class="fas fa-check-circle"></i> <?php echo app('translator')->get('Copied to clipboard!'); ?>
        </span>

        <form id="depositForm">
            <?php echo csrf_field(); ?>
            <button class="dgb-generate-btn" id="submitBtn" type="submit">
                <i class="fas fa-qrcode"></i> <?php echo app('translator')->get('GENERATE DEPOSIT ADDRESS'); ?>
            </button>
        </form>
    </div>

    <!-- Deposits Table -->
    <h4 class="dgb-section-title">
        <i class="fas fa-history"></i> <?php echo app('translator')->get('Your Deposits'); ?>
    </h4>

    <div class="dgb-table-container">
        <table class="dgb-table">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('TIME'); ?></th>
                    <th><?php echo app('translator')->get('WALLET'); ?></th>
                    <th><?php echo app('translator')->get('TRX NUMBER'); ?></th>
                    <th><?php echo app('translator')->get('AMOUNT'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="text-center" colspan="100%"><?php echo app('translator')->get('NO DATA AVAILABLE'); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="dgb-table-empty">
                            <i class="fas fa-inbox" style="font-size: 24px; margin-bottom: 10px; display: block; opacity: 0.3;"></i>
                            <?php echo app('translator')->get('NO DATA AVAILABLE'); ?>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <?php if($deposits->hasPages()): ?>
            <div style="margin-top: 20px;">
                <?php echo e(paginateLinks($deposits)); ?>

            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            // ==================== BACKGROUND ANIMATIONS ====================
            const dashboardStarsCanvas = document.getElementById('dashboardStars');
            if (dashboardStarsCanvas) {
                const dashboardStarsCtx = dashboardStarsCanvas.getContext('2d');
                dashboardStarsCanvas.width = window.innerWidth;
                dashboardStarsCanvas.height = window.innerHeight;
                
                const dashboardStars = [];
                const dashboardStarCount = window.innerWidth < 768 ? 150 : 200;
                
                for (let i = 0; i < dashboardStarCount; i++) {
                    dashboardStars.push({
                        x: Math.random() * dashboardStarsCanvas.width,
                        y: Math.random() * dashboardStarsCanvas.height,
                        radius: Math.random() * 2,
                        opacity: Math.random(),
                        speed: Math.random() * 0.5
                    });
                }
                
                function animateDashboardStars() {
                    dashboardStarsCtx.clearRect(0, 0, dashboardStarsCanvas.width, dashboardStarsCanvas.height);
                    dashboardStars.forEach(star => {
                        dashboardStarsCtx.beginPath();
                        dashboardStarsCtx.arc(star.x, star.y, star.radius, 0, Math.PI * 2);
                        dashboardStarsCtx.fillStyle = `rgba(0, 255, 255, ${star.opacity})`;
                        dashboardStarsCtx.fill();
                        
                        star.opacity += star.speed * 0.01;
                        if (star.opacity > 1 || star.opacity < 0) {
                            star.speed *= -1;
                        }
                    });
                    requestAnimationFrame(animateDashboardStars);
                }
                animateDashboardStars();
                
                window.addEventListener('resize', function() {
                    dashboardStarsCanvas.width = window.innerWidth;
                    dashboardStarsCanvas.height = window.innerHeight;
                });
            }
            
            function createDashboardMatrixRain() {
                const matrixContainer = document.getElementById('dashboardMatrixRain');
                if (!matrixContainer) return;
                
                const codeSnippets = [
                    'validateBlock()', 'mineDigiByte()', 'hashAlgorithm()', 'blockchain.add()',
                    'smartContract()', 'SHA256(hash)', 'verifyTx()', '0xDGB...', 'nonce++',
                    'difficulty:18', 'blockHeight++', 'merkleRoot()', 'utxo.verify()',
                    'consensus()', 'peer.sync()', 'wallet.sign()', 'tx.broadcast()',
                    'reward:10%', 'hashrate:100%', 'block.time:15s'
                ];
                
                const columnCount = Math.floor(window.innerWidth / (window.innerWidth < 768 ? 120 : 100));
                
                for (let i = 0; i < columnCount; i++) {
                    const column = document.createElement('div');
                    column.className = 'dashboard-matrix-column';
                    column.style.left = `${i * (window.innerWidth < 768 ? 120 : 100) + Math.random() * 50}px`;
                    column.style.animationDuration = `${Math.random() * (window.innerWidth < 768 ? 20 : 15) + 15}s`;
                    column.style.animationDelay = `${Math.random() * 5}s`;
                    
                    let text = '';
                    const lineCount = Math.floor(Math.random() * 10 + 20);
                    for (let j = 0; j < lineCount; j++) {
                        text += codeSnippets[Math.floor(Math.random() * codeSnippets.length)] + '\n';
                    }
                    column.textContent = text;
                    
                    matrixContainer.appendChild(column);
                }
            }
            
            createDashboardMatrixRain();

            // Function to handle form submission and display deposit address
            $('#depositForm').on('submit', function(e) {
                e.preventDefault();
                $('#waitingLoader').removeClass('d-none');
                $('#submitBtn').attr('disabled', 'disabled');
                $('.error-message').addClass('d-none');
                var data = $(this).serialize();
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('account.deposit')); ?>",
                    data: data,
                    dataType: "json",
                    success: function(data) {
                        if (data.error) {
                            $('#waitingLoader').addClass('d-none');
                            $('#submitBtn').removeAttr('disabled');
                            $('.error-message').removeClass('d-none').text(data.error);
                        } else {
                            $('#waitingLoader').addClass('d-none');
                            $('#depositForm').hide();
                            $('.deposit-address').text(data.address).removeClass('d-none');
                            $('#copyBtn').removeClass('d-none');
                        }
                    }
                });
            });

            // Function to copy the deposit address to the clipboard
            $('#copyBtn').on('click', function() {
                var addressText = $('.deposit-address').text();
                var tempInput = document.createElement('input');
                tempInput.value = addressText;
                document.body.appendChild(tempInput);
                tempInput.select();
                document.execCommand('copy');
                document.body.removeChild(tempInput);

                // Show success message after copying
                $('.copy-success-message').removeClass('d-none').hide().fadeIn().delay(2000).fadeOut();
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stellar/public_html/core/resources/views/templates/basic/account/deposit.blade.php ENDPATH**/ ?>