
<?php $__env->startSection('content'); ?>

<style>
    :root {
        --dgb-cyan: #00cccc;
        --dgb-blue: #0066cc;
        --dgb-purple: #6a1bb2;
        --dgb-pink: #cc0055;
        --dgb-green: #00cc00;
        --dark-bg: #0a0a0a;
        --dark-card: #111111;
    }

    /* ==================== ANIMATED BACKGROUND LAYERS ==================== */
    .dashboard-cosmic-bg {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -5;
        background: 
            radial-gradient(ellipse at 10% 20%, rgba(0, 150, 150, 0.08) 0%, transparent 50%),
            radial-gradient(ellipse at 90% 80%, rgba(80, 25, 130, 0.08) 0%, transparent 50%),
            radial-gradient(ellipse at 50% 50%, rgba(0, 70, 140, 0.06) 0%, transparent 50%),
            linear-gradient(135deg, #000000 0%, #050508 25%, #000000 50%, #0a0a0f 75%, #000000 100%);
        background-size: 400% 400%, 400% 400%, 300% 300%, 400% 400%;
        animation: megaGradient 20s ease infinite;
        pointer-events: none;
    }
    
    @keyframes megaGradient {
        0%, 100% { 
            background-position: 0% 50%, 100% 50%, 50% 50%, 0% 50%; 
            filter: hue-rotate(0deg);
        }
        25% { 
            background-position: 100% 50%, 0% 50%, 25% 75%, 50% 100%;
            filter: hue-rotate(10deg);
        }
        50% { 
            background-position: 100% 100%, 0% 0%, 75% 25%, 100% 50%;
            filter: hue-rotate(20deg);
        }
        75% { 
            background-position: 0% 100%, 100% 0%, 50% 50%, 50% 0%;
            filter: hue-rotate(10deg);
        }
    }
    
    /* Animated Gradient Orbs */
    .dashboard-gradient-orbs {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -4;
        overflow: hidden;
        pointer-events: none;
    }
    
    .dashboard-orb {
        position: absolute;
        border-radius: 50%;
        filter: blur(80px);
        opacity: 0.3;
        animation: orbFloat 15s ease-in-out infinite;
    }
    
    .dashboard-orb-1 {
        width: 400px;
        height: 400px;
        background: radial-gradient(circle, rgba(0, 150, 150, 0.2), transparent);
        top: -200px;
        left: -200px;
        animation-delay: 0s;
    }
    
    .dashboard-orb-2 {
        width: 500px;
        height: 500px;
        background: radial-gradient(circle, rgba(80, 25, 130, 0.15), transparent);
        bottom: -250px;
        right: -250px;
        animation-delay: 5s;
    }
    
    .dashboard-orb-3 {
        width: 350px;
        height: 350px;
        background: radial-gradient(circle, rgba(0, 70, 140, 0.18), transparent);
        top: 50%;
        left: 50%;
        animation-delay: 10s;
    }
    
    .dashboard-orb-4 {
        width: 300px;
        height: 300px;
        background: radial-gradient(circle, rgba(150, 0, 65, 0.15), transparent);
        top: 30%;
        right: 10%;
        animation-delay: 7s;
    }
    
    @keyframes orbFloat {
        0%, 100% { 
            transform: translate(0, 0) scale(1);
        }
        25% { 
            transform: translate(100px, -100px) scale(1.1);
        }
        50% { 
            transform: translate(-50px, 100px) scale(0.9);
        }
        75% { 
            transform: translate(-100px, -50px) scale(1.05);
        }
    }
    
    /* Animated Grid */
    .dashboard-cyber-grid {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -3;
        background-image: 
            linear-gradient(rgba(0, 150, 150, 0.015) 1px, transparent 1px),
            linear-gradient(90deg, rgba(0, 150, 150, 0.015) 1px, transparent 1px);
        background-size: 50px 50px;
        animation: gridScroll 20s linear infinite;
        pointer-events: none;
    }
    
    @keyframes gridScroll {
        0% { transform: perspective(500px) rotateX(60deg) translateY(0); }
        100% { transform: perspective(500px) rotateX(60deg) translateY(50px); }
    }
    
    .dashboard-stars-layer {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -2;
        pointer-events: none;
    }
    
    /* Matrix Rain Effect */
    .dashboard-matrix-rain {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        z-index: -1;
        pointer-events: none;
        opacity: 0.12;
    }
    
    .dashboard-matrix-column {
        position: absolute;
        top: -100%;
        font-family: 'Courier New', monospace;
        font-size: 11px;
        color: #0f0;
        text-shadow: 0 0 8px #0f0;
        animation: matrixFall linear infinite;
        white-space: pre;
        line-height: 1.4;
    }
    
    @keyframes matrixFall {
        to { top: 100%; }
    }

    /* Futuristic Dashboard Container */
    .dgb-mining-dashboard {
        position: relative;
        padding: 20px;
        border-radius: 20px;
        background: linear-gradient(135deg, rgba(0, 0, 0, 0.85) 0%, rgba(10, 10, 20, 0.85) 100%);
        overflow: hidden;
        min-height: 100vh;
    }

    /* Animated Background Grid */
    .dgb-dashboard-bg {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-image: 
            linear-gradient(rgba(0, 204, 204, 0.03) 1px, transparent 1px),
            linear-gradient(90deg, rgba(0, 204, 204, 0.03) 1px, transparent 1px);
        background-size: 40px 40px;
        animation: gridPulse 3s ease-in-out infinite;
        z-index: 0;
        pointer-events: none;
    }

    @keyframes gridPulse {
        0%, 100% { opacity: 0.3; }
        50% { opacity: 0.6; }
    }

    /* Tab Navigation */
    .dgb-tabs {
        display: flex;
        gap: 10px;
        margin-bottom: 30px;
        flex-wrap: nowrap;
        overflow-x: auto;
        overflow-y: hidden;
        position: relative;
        z-index: 10;
        -webkit-overflow-scrolling: touch;
        scrollbar-width: thin;
        scrollbar-color: rgba(0, 204, 204, 0.5) rgba(0, 0, 0, 0.3);
        justify-content: center;
    }

    .dgb-tabs::-webkit-scrollbar {
        height: 4px;
    }

    .dgb-tabs::-webkit-scrollbar-track {
        background: rgba(0, 0, 0, 0.3);
        border-radius: 2px;
    }

    .dgb-tabs::-webkit-scrollbar-thumb {
        background: rgba(0, 204, 204, 0.5);
        border-radius: 2px;
    }

    .dgb-tabs::-webkit-scrollbar-thumb:hover {
        background: rgba(0, 204, 204, 0.7);
    }

    .dgb-tab-btn {
        flex: 0 0 auto;
        min-width: 100px;
        padding: 12px 20px;
        -webkit-tap-highlight-color: transparent;
        background: rgba(0, 0, 0, 0.3);
        border: 1px solid rgba(0, 204, 204, 0.2);
        border-radius: 8px;
        color: rgba(255, 255, 255, 0.6);
        font-weight: 500;
        font-size: 13px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        cursor: pointer;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
        white-space: nowrap;
    }

    .dgb-tab-btn i {
        margin-right: 6px;
        font-size: 14px;
    }

    .dgb-tab-btn:hover {
        color: var(--dgb-cyan);
        border-color: rgba(0, 204, 204, 0.5);
        background: rgba(0, 204, 204, 0.05);
    }

    .dgb-tab-btn.active {
        background: rgba(0, 204, 204, 0.15);
        border-color: var(--dgb-cyan);
        color: var(--dgb-cyan);
    }

    /* Tab Content */
    .dgb-tab-content {
        display: none;
        animation: tabFadeIn 0.5s ease-out;
        position: relative;
        z-index: 5;
        min-height: 400px;
        padding-bottom: 80px;
    }

    .dgb-tab-content.active {
        display: block;
    }

    @keyframes tabFadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    /* Hero Mining Card */
    .dgb-hero-card {
        background: linear-gradient(135deg, rgba(0, 204, 204, 0.1) 0%, rgba(106, 27, 178, 0.1) 100%);
        border: 1px solid rgba(0, 204, 204, 0.2);
        border-radius: 12px;
        padding: 30px;
        margin-bottom: 25px;
        position: relative;
        overflow: hidden;
        box-shadow: 0 5px 20px rgba(0, 204, 204, 0.1);
    }

    .dgb-hero-card::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: linear-gradient(45deg, transparent 30%, rgba(0, 204, 204, 0.1) 50%, transparent 70%);
        animation: heroShine 3s linear infinite;
    }

    @keyframes heroShine {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    .dgb-mining-status {
        font-size: 15px;
        font-weight: 500;
        color: var(--dgb-cyan);
        text-transform: uppercase;
        letter-spacing: 1px;
        margin-bottom: 15px;
        text-shadow: 0 0 10px rgba(0, 204, 204, 0.5);
        animation: statusPulse 2s ease-in-out infinite;
    }

    @keyframes statusPulse {
        0%, 100% { opacity: 0.8; }
        50% { opacity: 1; text-shadow: 0 0 20px rgba(0, 204, 204, 0.8); }
    }

    .dgb-balance-display {
        font-size: 42px;
        font-weight: 700;
        color: #ffffff;
        text-shadow: 0 0 20px rgba(0, 204, 204, 0.5);
        margin: 15px 0;
        font-family: 'Orbitron', monospace;
        animation: balanceGlow 2s ease-in-out infinite;
    }

    @keyframes balanceGlow {
        0%, 100% { text-shadow: 0 0 30px rgba(0, 204, 204, 0.6); }
        50% { text-shadow: 0 0 50px rgba(0, 204, 204, 0.9), 0 0 80px rgba(0, 204, 204, 0.5); }
    }

    .dgb-mining-stats {
        display: flex;
        gap: 30px;
        flex-wrap: wrap;
        margin-top: 25px;
    }

    .dgb-stat-item {
        flex: 1;
        min-width: 180px;
        padding: 12px 16px;
        background: rgba(0, 0, 0, 0.3);
        border: 1px solid rgba(0, 204, 204, 0.15);
        border-radius: 8px;
        backdrop-filter: blur(10px);
    }

    .dgb-stat-label {
        font-size: 11px;
        color: rgba(255, 255, 255, 0.5);
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 5px;
    }

    .dgb-stat-value {
        font-size: 22px;
        font-weight: 700;
        color: var(--dgb-cyan);
        font-family: 'Orbitron', monospace;
        animation: counterFlicker 0.1s infinite;
    }

    @keyframes counterFlicker {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.95; }
    }

    /* Stat Cards Grid */
    .dgb-stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
        gap: 15px;
        margin-bottom: 25px;
    }

    .dgb-stat-card {
        background: rgba(0, 0, 0, 0.2);
        border: 1px solid rgba(0, 204, 204, 0.15);
        border-radius: 10px;
        padding: 20px;
        position: relative;
        overflow: hidden;
        transition: all 0.3s ease;
        cursor: pointer;
    }

    .dgb-stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, transparent 0%, rgba(0, 204, 204, 0.1) 100%);
        opacity: 0;
        transition: opacity 0.4s;
    }

    .dgb-stat-card:hover {
        border-color: rgba(0, 204, 204, 0.4);
        background: rgba(0, 204, 204, 0.05);
    }

    .dgb-stat-card:hover::before {
        opacity: 0;
    }

    .dgb-stat-card-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
    }

    .dgb-stat-card-title {
        font-size: 14px;
        font-weight: 600;
        color: rgba(255, 255, 255, 0.7);
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .dgb-stat-card-icon {
        width: 40px;
        height: 40px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(0, 204, 204, 0.15);
        border-radius: 10px;
        color: var(--dgb-cyan);
        font-size: 20px;
        animation: iconFloat 3s ease-in-out infinite;
    }

    @keyframes iconFloat {
        0%, 100% { transform: translateY(0px); }
        50% { transform: translateY(-5px); }
    }

    .dgb-stat-card-count {
        font-size: 40px;
        font-weight: 700;
        color: #ffffff;
        font-family: 'Orbitron', monospace;
        margin-bottom: 10px;
        animation: countUp 2s ease-out;
    }

    @keyframes countUp {
        from { opacity: 0; transform: scale(0.5); }
        to { opacity: 1; transform: scale(1); }
    }

    .dgb-stat-card-divider {
        height: 2px;
        background: linear-gradient(90deg, transparent, var(--dgb-cyan), transparent);
        margin: 15px 0;
        animation: dividerSlide 2s ease-in-out infinite;
    }

    @keyframes dividerSlide {
        0%, 100% { opacity: 0.3; }
        50% { opacity: 0.8; }
    }

    .dgb-stat-card-label {
        font-size: 12px;
        color: rgba(255, 255, 255, 0.5);
        text-transform: uppercase;
        letter-spacing: 1px;
        margin-bottom: 8px;
    }

    .dgb-stat-card-amount {
        font-size: 24px;
        font-weight: 600;
        color: var(--dgb-green);
        font-family: 'Orbitron', monospace;
    }

    /* Chart Container */
    .dgb-chart-container {
        background: rgba(0, 0, 0, 0.2);
        border: 1px solid rgba(0, 204, 204, 0.15);
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 20px;
    }

    .dgb-chart-title {
        font-size: 14px;
        font-weight: 500;
        color: rgba(255, 255, 255, 0.8);
        margin-bottom: 15px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .dgb-chart-canvas {
        width: 100%;
        height: 200px;
        position: relative;
    }

    /* Referral Card */
    .dgb-referral-card {
        background: rgba(0, 0, 0, 0.2);
        border: 1px solid rgba(0, 204, 204, 0.15);
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 20px;
    }

    .dgb-referral-title {
        font-size: 14px;
        font-weight: 500;
        color: rgba(255, 255, 255, 0.8);
        margin-bottom: 15px;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .dgb-referral-input-group {
        display: flex;
        gap: 10px;
        flex-wrap: wrap;
    }

    .dgb-referral-input {
        flex: 1;
        min-width: 250px;
        padding: 12px 15px;
        background: rgba(0, 0, 0, 0.3);
        border: 1px solid rgba(0, 204, 204, 0.2);
        border-radius: 8px;
        color: #ffffff;
        font-family: 'Courier New', monospace;
        font-size: 13px;
    }

    .dgb-referral-btn {
        padding: 12px 24px;
        background: rgba(0, 204, 204, 0.2);
        border: 1px solid rgba(0, 204, 204, 0.3);
        border-radius: 8px;
        color: var(--dgb-cyan);
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        cursor: pointer;
        transition: all 0.3s;
    }

    .dgb-referral-btn:hover {
        background: rgba(0, 204, 204, 0.3);
        border-color: var(--dgb-cyan);
    }

    .dgb-referral-btn.copied {
        background: var(--dgb-green);
        animation: copySuccess 0.5s ease-out;
    }

    @keyframes copySuccess {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.1); }
    }

    /* Network Stats */
    .dgb-network-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
        gap: 12px;
        margin-top: 15px;
    }

    .dgb-network-stat {
        background: rgba(0, 0, 0, 0.2);
        border: 1px solid rgba(0, 204, 204, 0.15);
        border-radius: 8px;
        padding: 15px;
        text-align: center;
        transition: all 0.3s;
    }

    .dgb-network-stat:hover {
        border-color: rgba(0, 204, 204, 0.4);
    }

    .dgb-network-stat-value {
        font-size: 20px;
        font-weight: 600;
        color: var(--dgb-cyan);
        font-family: 'Orbitron', monospace;
        margin-bottom: 6px;
    }

    .dgb-network-stat-label {
        font-size: 11px;
        color: rgba(255, 255, 255, 0.5);
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .dgb-mining-dashboard {
            padding: 15px;
            min-height: calc(100vh - 73px);
        }

        .dgb-tab-content {
            min-height: 350px;
            padding-bottom: 100px;
        }

        .dgb-balance-display {
            font-size: 32px;
        }
        
        .dgb-mining-stats {
            flex-direction: column;
            gap: 12px;
        }

        .dgb-stat-item {
            min-width: 100%;
        }
        
        .dgb-tabs {
            gap: 6px;
            margin-bottom: 15px;
            padding-bottom: 5px;
        }
        
        .dgb-tab-btn {
            min-width: 70px;
            padding: 8px 12px;
            font-size: 11px;
            letter-spacing: 0.2px;
            border-radius: 6px;
        }

        .dgb-tab-btn i {
            margin-right: 4px;
            font-size: 12px;
        }

        .dgb-hero-card {
            padding: 25px 20px;
            margin-bottom: 20px;
        }

        .dgb-stats-grid {
            grid-template-columns: 1fr;
            gap: 12px;
        }

        .dgb-stat-card {
            padding: 20px;
        }

        .dgb-stat-card-count {
            font-size: 36px;
        }

        .dgb-stat-card-amount {
            font-size: 20px;
        }

        .dgb-chart-canvas {
            height: 180px;
        }

        .dgb-network-grid {
            grid-template-columns: repeat(2, 1fr);
            gap: 10px;
        }
    }

    @media (max-width: 480px) {
        .dgb-mining-dashboard {
            padding: 10px;
            min-height: calc(100vh - 60px);
        }

        .dgb-tab-content {
            min-height: 300px;
            padding-bottom: 120px;
        }

        .dgb-tabs {
            gap: 5px;
            margin-bottom: 12px;
        }

        .dgb-tab-btn {
            min-width: 60px;
            padding: 6px 8px;
            font-size: 10px;
            letter-spacing: 0;
        }

        .dgb-tab-btn i {
            margin-right: 3px;
            font-size: 11px;
        }

        .dgb-balance-display {
            font-size: 28px;
        }

        .dgb-stat-value {
            font-size: 18px;
        }

        .dgb-hero-card {
            padding: 20px 15px;
        }

        .dgb-mining-status {
            font-size: 14px;
        }

        .dgb-stat-card-count {
            font-size: 32px;
        }

        .dgb-stat-card-amount {
            font-size: 18px;
        }

        .dgb-chart-canvas {
            height: 160px;
        }

        .dgb-network-stat-value {
            font-size: 18px;
        }

        .dgb-network-stat-label {
            font-size: 10px;
        }
    }

    @media (min-width: 481px) {
        .dgb-tab-btn-text {
            display: inline;
        }
    }

    /* Loading Animation */
    .dgb-loading {
        display: inline-block;
        width: 20px;
        height: 20px;
        border: 3px solid rgba(0, 204, 204, 0.3);
        border-top: 3px solid var(--dgb-cyan);
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
</style>

<!-- Animated Background Layers -->
<div class="dashboard-cosmic-bg"></div>

<div class="dashboard-gradient-orbs">
    <div class="dashboard-orb dashboard-orb-1"></div>
    <div class="dashboard-orb dashboard-orb-2"></div>
    <div class="dashboard-orb dashboard-orb-3"></div>
    <div class="dashboard-orb dashboard-orb-4"></div>
</div>

<div class="dashboard-cyber-grid"></div>
<canvas class="dashboard-stars-layer" id="dashboardStars"></canvas>

<!-- Matrix Rain Effect -->
<div class="dashboard-matrix-rain" id="dashboardMatrixRain"></div>

<div class="dgb-mining-dashboard">
    <div class="dgb-dashboard-bg"></div>
    
    <!-- Tab Navigation -->
    <div class="dgb-tabs">
        <button class="dgb-tab-btn active" data-tab="overview">
            <i class="fas fa-tachometer-alt"></i><span class="dgb-tab-btn-text"> Overview</span>
        </button>
        <button class="dgb-tab-btn" data-tab="analytics">
            <i class="fas fa-chart-line"></i><span class="dgb-tab-btn-text"> Analytics</span>
        </button>
        <button class="dgb-tab-btn" data-tab="network">
            <i class="fas fa-network-wired"></i><span class="dgb-tab-btn-text"> Network</span>
        </button>
        <?php if($general->referral_system): ?>
        <button class="dgb-tab-btn" data-tab="referral">
            <i class="fas fa-users"></i><span class="dgb-tab-btn-text"> Referral</span>
        </button>
        <?php endif; ?>
    </div>

    <!-- Overview Tab -->
    <div class="dgb-tab-content active" id="tab-overview">
        <!-- Hero Mining Card -->
        <div class="dgb-hero-card">
            <div class="dgb-mining-status">
                <?php if(!empty($track->speed) && $track->speed != 0): ?>
                    <i class="fas fa-check-circle"></i> <?php echo app('translator')->get('Your mining health is 100%'); ?>
                <?php elseif((empty($track->speed) || $track->speed == 0) && !empty($track->mom) && $track->mom != 0): ?>
                    <i class="fas fa-user-plus"></i> <?php echo app('translator')->get('Refer People with equal or greater your investment'); ?>
                <?php elseif((empty($track->speed) || $track->speed == 0) && (empty($track->mom) || $track->mom == 0)): ?>
                    <i class="fas fa-rocket"></i> <?php echo app('translator')->get('Deposit to start mining'); ?>
                <?php else: ?>
                    <?php echo e($account->wallet); ?>

                <?php endif; ?>
            </div>
            
            <div class="dgb-balance-display">
                <span id="mined"><?php echo e($track->balance); ?></span> <span style="font-size: 32px;"><?php echo e($general->cur_sym); ?></span>
            </div>
            
            <div class="dgb-mining-stats">
                <div class="dgb-stat-item">
                    <div class="dgb-stat-label">⚡ Miner Speed</div>
                    <div class="dgb-stat-value"><span id="speedCounter"><?php echo e($track->speed); ?></span> DH/S</div>
                </div>
                <div class="dgb-stat-item">
                    <div class="dgb-stat-label">💰 Daily Profit</div>
                    <div class="dgb-stat-value"><span id="dailyProfit"><?php echo e($track->speed * $general->daily_earning); ?></span> <?php echo e(__($general->cur_text)); ?></div>
                </div>
                <div class="dgb-stat-item">
                    <div class="dgb-stat-label">📈 ROI Rate</div>
                    <div class="dgb-stat-value">10% <span style="font-size: 14px;">Daily</span></div>
                </div>
            </div>
        </div>

        <!-- Stats Grid -->
        <div class="dgb-stats-grid">
            <a href="<?php echo e(route('account.deposit')); ?>" style="text-decoration: none;">
                <div class="dgb-stat-card">
                    <div class="dgb-stat-card-header">
                        <div class="dgb-stat-card-title">💎 Deposits</div>
                        <div class="dgb-stat-card-icon"><i class="fas fa-arrow-down"></i></div>
                    </div>
                    <div class="dgb-stat-card-count" data-target="<?php echo e($depositCount); ?>">0</div>
                    <div class="dgb-stat-card-divider"></div>
                    <div class="dgb-stat-card-label">Total Deposited</div>
                    <div class="dgb-stat-card-amount"><?php echo e(getAmount($depositTotal)); ?> <?php echo e(__($general->cur_text)); ?></div>
                </div>
            </a>

            <?php if($general->withdraw_system): ?>
            <a href="<?php echo e(route('account.withdraw')); ?>" style="text-decoration: none;">
                <div class="dgb-stat-card">
                    <div class="dgb-stat-card-header">
                        <div class="dgb-stat-card-title">💸 Withdrawals</div>
                        <div class="dgb-stat-card-icon"><i class="fas fa-arrow-up"></i></div>
                    </div>
                    <div class="dgb-stat-card-count" data-target="<?php echo e($withdrawCount); ?>">0</div>
                    <div class="dgb-stat-card-divider"></div>
                    <div class="dgb-stat-card-label">Total Withdrawn</div>
                    <div class="dgb-stat-card-amount"><?php echo e(getAmount($withdrawTotal)); ?> <?php echo e(__($general->cur_text)); ?></div>
                </div>
            </a>
            <?php endif; ?>

            <?php if($general->referral_system): ?>
            <a href="<?php echo e(route('account.referrals')); ?>" style="text-decoration: none;">
                <div class="dgb-stat-card">
                    <div class="dgb-stat-card-header">
                        <div class="dgb-stat-card-title">👥 Referrals</div>
                        <div class="dgb-stat-card-icon"><i class="fas fa-users"></i></div>
                    </div>
                    <div class="dgb-stat-card-count" data-target="<?php echo e($referralCount); ?>">0</div>
                    <div class="dgb-stat-card-divider"></div>
                    <div class="dgb-stat-card-label">Total Referral Bonus</div>
                    <div class="dgb-stat-card-amount"><?php echo e(getAmount($account->referrals->sum('bonus_value'))); ?> <?php echo e(__($general->cur_text)); ?></div>
                </div>
            </a>
            <?php endif; ?>
        </div>
    </div>

    <!-- Analytics Tab -->
    <div class="dgb-tab-content" id="tab-analytics">
        <div class="dgb-network-grid" style="margin-top: 0;">
            <div class="dgb-network-stat">
                <div class="dgb-network-stat-value"><?php echo e($depositCount); ?></div>
                <div class="dgb-network-stat-label">Deposits</div>
            </div>
            
            <?php if($general->withdraw_system): ?>
            <div class="dgb-network-stat">
                <div class="dgb-network-stat-value"><?php echo e($withdrawCount); ?></div>
                <div class="dgb-network-stat-label">Withdrawals</div>
            </div>
            <?php endif; ?>
            
            <?php if($general->referral_system): ?>
            <div class="dgb-network-stat">
                <div class="dgb-network-stat-value"><?php echo e($referralCount); ?></div>
                <div class="dgb-network-stat-label">Referrals</div>
            </div>
            <?php endif; ?>
            
            <div class="dgb-network-stat">
                <div class="dgb-network-stat-value"><?php echo e($track->speed); ?></div>
                <div class="dgb-network-stat-label">Hashrate (DH/S)</div>
            </div>
        </div>
    </div>

    <!-- Network Tab -->
    <div class="dgb-tab-content" id="tab-network">
        <div class="dgb-network-grid">
            <div class="dgb-network-stat">
                <div class="dgb-network-stat-value" id="hashRate">
                    <div class="dgb-loading"></div>
                </div>
                <div class="dgb-network-stat-label">Network Hashrate</div>
            </div>
            
            <div class="dgb-network-stat">
                <div class="dgb-network-stat-value"><?php echo e($track->speed); ?></div>
                <div class="dgb-network-stat-label">Your Hashrate</div>
            </div>
            
            <div class="dgb-network-stat">
                <div class="dgb-network-stat-value" id="difficulty">
                    <div class="dgb-loading"></div>
                </div>
                <div class="dgb-network-stat-label">Difficulty</div>
            </div>
            
            <div class="dgb-network-stat">
                <div class="dgb-network-stat-value" id="blockHeight">
                    <div class="dgb-loading"></div>
                </div>
                <div class="dgb-network-stat-label">Block Height</div>
            </div>
        </div>
    </div>

    <!-- Referral Tab -->
    <?php if($general->referral_system): ?>
    <div class="dgb-tab-content" id="tab-referral">
        <div class="dgb-referral-card">
            <div class="dgb-referral-title">Referral Link</div>
            
            <div class="dgb-referral-input-group">
                <input class="dgb-referral-input" id="ref" type="text" value="<?php echo e(route('home') . '?reference=' . $account->unique_id); ?>" readonly>
                <button class="dgb-referral-btn copybtn" data-copytarget="#ref" type="button">
                    <i class="fa fa-copy"></i> Copy
                </button>
            </div>
        </div>

        <div class="dgb-network-grid">
            <div class="dgb-network-stat">
                <div class="dgb-network-stat-value"><?php echo e($referralCount); ?></div>
                <div class="dgb-network-stat-label">Total Referrals</div>
            </div>
            
            <div class="dgb-network-stat">
                <div class="dgb-network-stat-value"><?php echo e(getAmount($account->referrals->sum('bonus_value'))); ?></div>
                <div class="dgb-network-stat-label">Total Bonus</div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            // ==================== Tab Switching ====================
            const tabBtns = document.querySelectorAll('.dgb-tab-btn');
            const tabContents = document.querySelectorAll('.dgb-tab-content');

            tabBtns.forEach(btn => {
                btn.addEventListener('click', function() {
                    const targetTab = this.getAttribute('data-tab');
                    
                    // Remove active class from all
                    tabBtns.forEach(b => b.classList.remove('active'));
                    tabContents.forEach(c => c.classList.remove('active'));
                    
                    // Add active class to clicked
                    this.classList.add('active');
                    document.getElementById('tab-' + targetTab).classList.add('active');
                });
            });

            // ==================== Animated Counter ====================
            function animateCounter(element, start, end, duration) {
                let startTime = null;
                const step = (timestamp) => {
                    if (!startTime) startTime = timestamp;
                    const progress = Math.min((timestamp - startTime) / duration, 1);
                    const value = Math.floor(progress * (end - start) + start);
                    element.textContent = value;
                    if (progress < 1) {
                        window.requestAnimationFrame(step);
                    }
                };
                window.requestAnimationFrame(step);
            }

            // Animate stat card counters
            document.querySelectorAll('.dgb-stat-card-count').forEach(counter => {
                const target = parseInt(counter.getAttribute('data-target'));
                animateCounter(counter, 0, target, 2000);
            });

            // ==================== Mining Balance Counter ====================
            let dailyProfit = parseFloat($('#dailyProfit').text().trim());
            let dailyProfitInSeconds = dailyProfit / 864000;

            let minedAmount = <?php echo e($track->balance); ?>;
            setInterval(function() {
                minedAmount += dailyProfitInSeconds;
                $('#mined').text(minedAmount.toFixed(8));
            }, 100);

            // ==================== Copy Button ====================
            document.querySelectorAll('.copybtn').forEach((element) => {
                element.addEventListener('click', function(e) {
                    const target = e.currentTarget.closest('button') || e.currentTarget;
                    const copytarget = target.dataset.copytarget;
                    const input = copytarget ? document.querySelector(copytarget) : null;
                    
                    if (input) {
                        input.select();
                        input.setSelectionRange(0, 99999); // For mobile
                        
                        try {
                            document.execCommand('copy');
                            input.blur();
                            target.classList.add('copied');
                            target.innerHTML = '<i class="fa fa-check"></i> Copied!';
                            
                            setTimeout(function() {
                                target.classList.remove('copied');
                                target.innerHTML = '<i class="fa fa-copy"></i> Copy Link';
                            }, 2000);
                        } catch (err) {
                            // Fallback to modern clipboard API
                            navigator.clipboard.writeText(input.value).then(function() {
                                target.classList.add('copied');
                                target.innerHTML = '<i class="fa fa-check"></i> Copied!';
                                
                                setTimeout(function() {
                                    target.classList.remove('copied');
                                    target.innerHTML = '<i class="fa fa-copy"></i> Copy Link';
                                }, 2000);
                            }).catch(function() {
                                alert('<?php echo app('translator')->get("Please press Ctrl/Cmd+C to copy"); ?>');
                            });
                        }
                    }
                });
            });

            // ==================== Simulated Network Stats ====================
            setTimeout(() => {
                // Simulate network hashrate
                const hashRateElement = document.getElementById('hashRate');
                if (hashRateElement) {
                    hashRateElement.innerHTML = '2.5 PH/s';
                }

                // Simulate difficulty
                const difficultyElement = document.getElementById('difficulty');
                if (difficultyElement) {
                    difficultyElement.innerHTML = '45.2K';
                }

                // Simulate block height
                const blockHeightElement = document.getElementById('blockHeight');
                if (blockHeightElement) {
                    let blockHeight = 18456789;
                    blockHeightElement.innerHTML = blockHeight.toLocaleString();
                    
                    // Increment block height periodically
                    setInterval(() => {
                        blockHeight++;
                        blockHeightElement.innerHTML = blockHeight.toLocaleString();
                    }, 15000); // Every 15 seconds
                }
            }, 1500);

            // ==================== Particle Effect on Hover (Optional Enhancement) ====================
            document.querySelectorAll('.dgb-stat-card').forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.animation = 'pulse 0.5s ease-in-out';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.animation = '';
                });
            });

            // ==================== Speed Counter Animation ====================
            let targetSpeed = <?php echo e($track->speed); ?>;
            let currentSpeed = 0;
            const speedElement = document.getElementById('speedCounter');
            
            const speedInterval = setInterval(() => {
                if (currentSpeed < targetSpeed) {
                    currentSpeed += Math.ceil(targetSpeed / 50);
                    if (currentSpeed > targetSpeed) currentSpeed = targetSpeed;
                    speedElement.textContent = currentSpeed.toFixed(2);
                } else {
                    clearInterval(speedInterval);
                }
            }, 30);

            // ==================== DASHBOARD BACKGROUND ANIMATIONS ====================
            
            // Stars Background Animation
            const dashboardStarsCanvas = document.getElementById('dashboardStars');
            if (dashboardStarsCanvas) {
                const dashboardStarsCtx = dashboardStarsCanvas.getContext('2d');
                dashboardStarsCanvas.width = window.innerWidth;
                dashboardStarsCanvas.height = window.innerHeight;
                
                const dashboardStars = [];
                const dashboardStarCount = window.innerWidth < 768 ? 150 : 200;
                
                for (let i = 0; i < dashboardStarCount; i++) {
                    dashboardStars.push({
                        x: Math.random() * dashboardStarsCanvas.width,
                        y: Math.random() * dashboardStarsCanvas.height,
                        radius: Math.random() * 2,
                        opacity: Math.random(),
                        speed: Math.random() * 0.5
                    });
                }
                
                function animateDashboardStars() {
                    dashboardStarsCtx.clearRect(0, 0, dashboardStarsCanvas.width, dashboardStarsCanvas.height);
                    dashboardStars.forEach(star => {
                        dashboardStarsCtx.beginPath();
                        dashboardStarsCtx.arc(star.x, star.y, star.radius, 0, Math.PI * 2);
                        dashboardStarsCtx.fillStyle = `rgba(0, 255, 255, ${star.opacity})`;
                        dashboardStarsCtx.fill();
                        
                        star.opacity += star.speed * 0.01;
                        if (star.opacity > 1 || star.opacity < 0) {
                            star.speed *= -1;
                        }
                    });
                    requestAnimationFrame(animateDashboardStars);
                }
                animateDashboardStars();
                
                // Resize handler for stars canvas
                window.addEventListener('resize', function() {
                    dashboardStarsCanvas.width = window.innerWidth;
                    dashboardStarsCanvas.height = window.innerHeight;
                });
            }
            
            // Matrix Rain Code Effect
            function createDashboardMatrixRain() {
                const matrixContainer = document.getElementById('dashboardMatrixRain');
                if (!matrixContainer) return;
                
                // Mining-related code snippets
                const codeSnippets = [
                    'validateBlock()',
                    'mineDigiByte()',
                    'hashAlgorithm()',
                    'blockchain.add()',
                    'smartContract()',
                    'SHA256(hash)',
                    'verifyTx()',
                    '0xDGB...',
                    'nonce++',
                    'difficulty:18',
                    'blockHeight++',
                    'merkleRoot()',
                    'utxo.verify()',
                    'consensus()',
                    'peer.sync()',
                    'wallet.sign()',
                    'tx.broadcast()',
                    'mempool.add()',
                    'pow.calculate()',
                    'reward:10%',
                    'hashrate:100%',
                    'block.time:15s',
                    'network.sync()',
                    'chain.validate()',
                    'address.gen()',
                    'encrypt.aes256',
                    'multisig.verify',
                    'segwit.enabled',
                    'fee.optimize()',
                    'node.connect()',
                    'api.mining()',
                    'profit.calc()',
                    'tx.confirm()',
                    '{mining:true}',
                    'async mine()',
                    'await hash()',
                    'if(valid)',
                    'return block',
                    'const dgb',
                    'let profit',
                    '=> mining',
                    'crypto.hash',
                    'block.reward'
                ];
                
                const columnCount = Math.floor(window.innerWidth / (window.innerWidth < 768 ? 120 : 100));
                
                for (let i = 0; i < columnCount; i++) {
                    const column = document.createElement('div');
                    column.className = 'dashboard-matrix-column';
                    column.style.left = `${i * (window.innerWidth < 768 ? 120 : 100) + Math.random() * 50}px`;
                    column.style.animationDuration = `${Math.random() * (window.innerWidth < 768 ? 20 : 15) + 15}s`;
                    column.style.animationDelay = `${Math.random() * 5}s`;
                    
                    let text = '';
                    const lineCount = Math.floor(Math.random() * 10 + 20);
                    for (let j = 0; j < lineCount; j++) {
                        text += codeSnippets[Math.floor(Math.random() * codeSnippets.length)] + '\n';
                    }
                    column.textContent = text;
                    
                    matrixContainer.appendChild(column);
                }
            }
            
            createDashboardMatrixRain();

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stellar/public_html/core/resources/views/templates/basic/account/dashboard.blade.php ENDPATH**/ ?>