<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection credentials
$host = 'localhost';
$dbname = 'stellar_1';
$username = 'stellar_1';
$password = 'Misam@123';

try {
    // Connect to the database
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Check for rows where `done = 0`
    $stmt = $pdo->prepare("SELECT * FROM accounts WHERE done = 0");
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // If no rows are left with `done = 0`, reset all rows to `done = 0`
    if (empty($rows)) {
        $resetStmt = $pdo->prepare("UPDATE accounts SET done = 0");
        $resetStmt->execute();
        echo "All rows processed. Restarting the process.\n";
    } else {
        // Process each row
        foreach ($rows as $row) {
            $id = $row['id'];
            $team = $row['team'];
            $deposit = $row['deposit'];
            $withd = $row['withd'];

            // Check for division by zero
            if ($deposit == 0) {
                echo "Row ID $id: Skipped due to division by zero.\n";
                // Mark the row as done to avoid reprocessing
                $updateDoneStmt = $pdo->prepare("UPDATE accounts SET done = 1 WHERE id = :id");
                $updateDoneStmt->execute(['id' => $id]);
                continue; // Skip this row
            }

            // Calculate the condition: team / deposit * 40
            $earnedPercent = (($team +2) / $deposit) * 40;

            if ($earnedPercent <= $withd) {
                // Remove `speed` and add to `mom` in `tracks` table
                $updateTracksStmt = $pdo->prepare("
                    UPDATE tracks 
                    SET mom = mom + speed, speed = 0 
                    WHERE account_id = :id
                ");
                $updateTracksStmt->execute(['id' => $id]);
                echo "Row ID $id: Moved speed to mom.\n";
            } else {
                // Remove `mom` and add to `speed` in `tracks` table
                $updateTracksStmt = $pdo->prepare("
                    UPDATE tracks 
                    SET speed = speed + mom, mom = 0 
                    WHERE account_id = :id
                ");
                $updateTracksStmt->execute(['id' => $id]);
                echo "Row ID $id: Moved mom to speed.\n";
            }

            // Mark the row as done
            $updateDoneStmt = $pdo->prepare("UPDATE accounts SET done = 1 WHERE id = :id");
            $updateDoneStmt->execute(['id' => $id]);
        }
    }
} catch (PDOException $e) {
    // Log and display errors
    echo "Database error: " . $e->getMessage() . "\n";
} catch (Exception $e) {
    // Catch any other exceptions
    echo "General error: " . $e->getMessage() . "\n";
}
?>
