<?php

namespace App\Http\Controllers;

use App\Constants\Status;
use App\Lib\CoinPaymentHosted;
use App\Models\Account;
use App\Models\Deposit;
use App\Models\Gateway;
use App\Models\ReferralLog;
use App\Models\Track;
use App\Models\Withdrawal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PaymentController extends Controller
{
    public function depositWallet()
    {
        $account = session('ACCOUNT');
        $account = Account::where('wallet', $account)->first();
        $general = gs();

        $gateway     = Gateway::first();
        $coinPayment = new CoinPaymentHosted();
        $coinPayment->Setup($gateway->key_2, $gateway->key_1);
        $callbackUrl = route('ipn.coinPayment.deposit');
        $result      = $coinPayment->GetCallbackAddress($general->cur_text, $callbackUrl);
        if ($result['error'] == 'ok') {
            $wallet              = @$result['result']['address'];
            $deposit             = new Deposit();
            $deposit->account_id = $account->id;
            $deposit->amount     = 0;
            $deposit->wallet     = $wallet;
            $deposit->trx        = getTrx();
            $deposit->status     = 0;
            $deposit->save();
            return response()->json(['address' => $wallet]);
        } else {
            return response()->json(['error' => 'Sorry! something went wrong! ' . $result['error']]);
        }
    }


    public function ipnDeposit(Request $request)
{
    $deposit = Deposit::initiated()->where('wallet', $request->address)->orderBy('id', 'DESC')->first();

    if ($deposit) {
        $gateway = Gateway::first();

        if ($gateway->minimum_deposit > $request->amount) {
            $notify[] = ['error', 'Please follow the minimum deposit limit'];
            return back()->withNotify($notify);
        }

        $deposit->amount = $request->amount;
        $deposit->status = 1;
        $deposit->save();
        $general = gs();
        
        // Update mining speed
        $track = Track::where('account_id', $deposit->account_id)->first();
        $track->account_id = $deposit->account_id;
        $track->speed += $request->amount / $general->dhs_price;
        $track->save();

        $account = Account::find($deposit->account_id);

        if ($account && $general->referral_system) {
            $this->applyReferralBonus($account->ref_by, $deposit->account_id, $request->amount, $general, 1);
        }
    }
}

/**
 * Apply referral bonus for multiple levels.
 *
 * @param int $refByAccountId
 * @param int $refUserId
 * @param float $depositAmount
 * @param object $general
 * @param int $level
 */
protected function applyReferralBonus($refByAccountId, $refUserId, $depositAmount, $general, $level)
{
    // Define referral commissions for each level
    $referralCommissions = [
        1 => 7, // Level 1: 7%
        2 => 2, // Level 2: 5%
        3 => 1, // Level 3: 1%
    ];

    if ($level > 3 || !$refByAccountId) {
        return; // Stop if we exceed level 3 or there is no referrer
    }

    // Find the referrer's track
    $track = Track::where('account_id', $refByAccountId)->where('status', Status::ACTIVE)->first();

    if ($track && isset($referralCommissions[$level])) {
        $bonusAmount = ($depositAmount * $referralCommissions[$level]) / 100;
        $track->balance += $bonusAmount;
        $track->save();

        // Log the referral bonus
        $refLog = new ReferralLog();
        $refLog->account_id = $refByAccountId;
        $refLog->ref_user_id = $refUserId;
        $refLog->deposit_amount = $depositAmount;
        $refLog->bonus_value = $bonusAmount;
        $refLog->level = $level;
        $refLog->save();

        // Recursively apply the bonus for the next level
        $nextAccount = Account::find($refByAccountId);
        if ($nextAccount && $nextAccount->ref_by) {
            $this->applyReferralBonus($nextAccount->ref_by, $refUserId, $depositAmount, $general, $level + 1);
        }
    }
}




    public function withdrawMoney(Request $request)
    {
        $account = session()->get('ACCOUNT');
        $account = Account::where('wallet', $account)->first();
        $track   = Track::where('account_id', $account->id)->first();
        if ($track) {
            $gateway  = Gateway::first();
            $validate = Validator::make($request->except('_token'), [
                "amount" => "required|numeric|min:$gateway->minimum_withdraw|max:$gateway->maximum_withdraw",
            ]);

            if ($validate->fails()) {
                return response()->json(['error' => $validate->errors()->all()]);
            }
            if ($request->amount > $track->balance) {
                return response()->json(['error' => 'You don\'t have sufficient balance']);
            } else {
                $track->balance  = $track->balance - $request->amount;
                $track->withdraw = $track->withdraw + $request->amount;
                $track->save();
                $general = gs();
                $cps     = new CoinPaymentHosted();
                $cps->Setup($gateway->key_2, $gateway->key_1);
                $result = $cps->CreateWithdrawal($request->amount, strtoupper($general->cur_text), $account->wallet, 1);

                if ($result['error'] == 'ok') {
                    $withdrawal             = new Withdrawal();
                    $withdrawal->account_id = $account->id;
                    $withdrawal->amount     = $request->amount;
                    $withdrawal->trx        = getTrx();
                    $withdrawal->save();
                    return response()->json(['success' => 'Withdrawal completed successfully']);
                } else {
                    $track->balance  = $track->balance + $request->amount;
                    $track->withdraw = $track->withdraw - $request->amount;
                    $track->save();
                    return response()->json(['error' => 'Something went wrong! ' . $result['error']]);
                }
            }
        } else {
            return response()->json(['error' => 'Track not found']);
        }
    }
}
