@extends($activeTemplate . 'layouts.master')
@section('content')
    <div class="card custom--card text--white mb-5">
        <div class="card-header py-3">
            <h5 class="card-title m-0">@lang('Your Deposit Address')</h5>
        </div>
        <div class="card-body py-3">
        <h4 class="card__dogecoin__balance text--white deposit-address d-none py-3"></h4>
<button class="cmn--btn copy-btn d-none" id="copyBtn" type="button" style="margin-top:10px;">
    @lang('Copy Address')
</button>
<span class="copy-success-message text--success d-none">@lang('Copied to clipboard!')</span>

            

            <div class="d-none mb-2" id="waitingLoader">
                <i class="las la-spinner"></i>
            </div>
            <h4 class="d-none error-message text--danger mb-2"></h4>
            <form id="depositForm">
                @csrf
                <button class="cmn--btn" id="submitBtn" type="submit">@lang('GENERATE DEPOSIT ADDRESS')</button>
            </form>
        </div>
        <div class="card-footer py-3">
            <span class="card__text">
                @lang('Minimum Deposit Limit'): {{ $gateway->minimum_deposit }} {{ __($general->cur_text) }}
                | @lang('1 DH/S') = {{ $general->dhs_price }} {{ __($general->cur_text) }}
                | @lang('Daily') <strong>{{ $general->daily_earning }}</strong> {{ __($general->cur_text) }} @lang('Per DH/S') <br>   @lang('Get 3-5% Daily')
            </span>
        </div>
    </div>
    <div class="active--miners">
        <h4 class="subtitle mb-4 pt-5 text-white">@lang('Your Deposits')</h4>
        <div class="table--responsive">
            <table class="cmn--table table--white">
                <thead>
                    <tr>
                        <th>@lang('TIME')</th>
                        <th>@lang('WALLET')</th>
                        <th>@lang('TRX NUMBER')</th>
                        <th>@lang('AMOUNT')</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($deposits as $item)
                        <tr>
                            <td>
                                <span>{{ showDateTime($item->created_at) }}</span>
                            </td>
                            <td>
                                {{ $item->wallet }}
                            </td>
                            <td>
                                <span>{{ $item->trx }}</span>
                            </td>
                            <td>
                                <span>{{ showAmount($item->amount, 8) }} {{ __($general->cur_text) }}</span>
                            </td>
                        </tr>

                    @empty
                        <tr>
                            <td class="text-center" colspan="100%">@lang('NO DATA AVAILABLE')</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            @if ($deposits->hasPages())
                {{ paginateLinks($deposits) }}
            @endif
        </div>
    </div>
@endsection

@push('script')
    <script>
        'use strict';
        (function($) {
            // Function to handle form submission and display deposit address
            $('#depositForm').on('submit', function(e) {
                e.preventDefault();
                $('#waitingLoader').removeClass('d-none').hide().show('slow');
                $('#submitBtn').attr('disabled', 'disabled');
                $('.error-message').addClass('d-none');
                var data = $(this).serialize();
                $.ajax({
                    type: "POST",
                    url: "{{ route('account.deposit') }}",
                    data: data,
                    dataType: "json",
                    success: function(data) {
                        if (data.error) {
                            $('#waitingLoader').addClass('d-none');
                            $('#submitBtn').removeAttr('disabled');
                            $('.error-message').removeClass('d-none').text(data.error);
                        } else {
                            $('#waitingLoader').addClass('d-none');
                            $('#depositForm').hide();
                            $('.deposit-address').text(data.address).removeClass('d-none');
                            $('#copyBtn').removeClass('d-none');
                            let qrcode = 'https://chart.googleapis.com/chart?chs=300x300&cht=qr&chl=' + data.address + '&choe=UTF-8';
                            $('#qrCodeImg').attr('src', qrcode);
                        }
                    }
                });
            });

            // Function to copy the deposit address to the clipboard
            $('#copyBtn').on('click', function() {
                var addressText = $('.deposit-address').text();
                var tempInput = document.createElement('input');
                tempInput.value = addressText;
                document.body.appendChild(tempInput);
                tempInput.select();
                document.execCommand('copy');
                document.body.removeChild(tempInput);

                // Show success message after copying
                $('.copy-success-message').removeClass('d-none').hide().fadeIn().delay(2000).fadeOut();
            });

        })(jQuery);
    </script>
@endpush
