@extends($activeTemplate . 'layouts.master')
@section('content')
    @php
        $content = getContent('user_dashboard.content', true);
    @endphp

    <div class="card custom--card text--white mb-5">
        <div class="card-header py-3">
            <h5 class="card-title m-0">{{ __($pageTitle) }}</h5>
        </div>
        <div class="card-body py-5">
            <form class="withdraw--form row mb--25" id="withdrawForm">
                @csrf
                <div class="form-group col-lg-10">
                    <div class="input-group m-0">
                        <input class="form-control form--control" name="amount" type="text" placeholder="Balance: {{ $track->balance }}">
                        <div class="input-group-append"></div>
                        <span class="input-group-text bg--base border--light text--white">{{ __($general->cur_text) }}</span>
                    </div>
                   
                </div>
                <div class="form-group col-lg-2">
                    <button class="cmn--btn form-control form--control d-block" id="submitBtn" type="submit">@lang('SUBMIT')</button>
                </div>
            </form>
        </div>
        <div class="card-footer py-3">
            <div class="row">
                <span class="col-lg-6">@lang('Minimum Limit'): {{ $gateway->minimum_withdraw }} {{ __($general->cur_text) }}</span>

                <span class="col-lg-6">@lang('Maximum Limit'): {{ $gateway->maximum_withdraw }} {{ __($general->cur_text) }}</span>

            </div>
        </div>
    </div>
    <div class="active--miners">
        <h4 class="subtitle mb-4 pt-5 text-white">@lang('Your Withdrawals')</h4>
        <div class="table--responsive">
            <table class="cmn--table table--white">
                <thead>
                    <tr>
                        <th>@lang('TIME')</th>
                        <th>@lang('TRX NUMBER')</th>
                        <th>@lang('AMOUNT')</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($withdrawals as $item)
                        <tr>
                            <td>
                                {{ showDateTime($item->created_at) }}
                            </td>
                            <td>
                                <span>{{ $item->trx }}</span>
                            </td>
                            <td>
                                <span>{{ showAmount($item->amount, 8) }} {{ __($general->cur_text) }}</span>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td class="text-center" colspan="100%">@lang('NO DATA AVAILABLE')</td>
                        </tr>
                    @endforelse

                </tbody>
            </table>
            @if ($withdrawals->hasPages())
                {{ paginateLinks($withdrawals) }}
            @endif
        </div>
    </div>
@endsection

@push('script')
    <script>
        'use strict';
        (function($) {
            $('#withdrawForm').on('submit', function(e) {
                e.preventDefault();
                let minLimit = parseFloat('{{ $gateway->minimum_withdraw }}');
                let maxLimit = parseFloat('{{ $gateway->maximum_withdraw }}');
                let inputAmount = parseFloat($(`[name="amount"]`).val());
                if (!inputAmount) {
                    notify('error', 'Withdraw amount required');
                } else if (inputAmount > maxLimit) {
                    notify('error', 'Please follow maximum withdraw limit');
                } else if (inputAmount < minLimit) {
                    notify('error', 'Please follow minimum withdraw limit');
                } else {
                    $('#submitBtn').attr('disabled', 'disabled');
                    notify("warning", 'The request is processing. Please wait for some time');
                    var data = $(this).serialize();
                    $.ajax({
                        type: "POST",
                        url: "{{ route('account.withdraw') }}",
                        data: data,
                        dataType: "json",
                        success: function(data) {
                            if (data.error) {
                                notify('error', data.error);
                                $('#submitBtn').removeAttr('disabled');
                            } else {
                                notify("success", data.success);
                            }
                        }
                    });
                }


            });
        })(jQuery)
    </script>
@endpush
