@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $content = getContent('blog.content', true);
    @endphp

    <section class="blog-section pt-120 pb-120 bg--section">
        <div class="container">
            <div class="row justify-content-center g-4">
                @foreach ($blogs as $blog)
                    <div class="col-lg-4 col-md-6 col-sm-12 mrb-30">
                        <div class="post__item">
                            <div class="post__thumb">
                                <img src="{{ getImage('assets/images/frontend/blog/thumb_' . @$blog->data_values->image, '410x270') }}" alt="@lang('Blog')">
                            </div>

                            <div class="post__content">
                                <h6 class="post__title">
                                    <a href="{{ route('blog.details', [slug(@$blog->data_values->title), $blog->id]) }}">{{ __(@$blog->data_values->title) }}</a>
                                </h6>

                                <div class="meta__date">
                                    <div class="meta__item">
                                        <i class="las la-calendar"></i>{{ showDateTime($blog->created_at, 'd, M') }}
                                    </div>

                                    <div class="meta__item">
                                        <i class="las la-user"></i>
                                        @lang(' Admin')
                                    </div>
                                </div>
                                <a class="post__read" href="{{ route('blog.details', [slug(@$blog->data_values->title), $blog->id]) }}">@lang('Read More') <i class="las la-long-arrow-alt-right"></i></a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            @if ($blogs->hasPages())
                {{ paginateLinks($blogs) }}
            @endif
        </div>
    </section>

    @if ($sections->secs != null)
        @foreach (json_decode($sections->secs) as $sec)
            @include($activeTemplate . 'sections.' . $sec)
        @endforeach
    @endif

@endsection
