<?php
    $bannerContent = getContent('banner.content', true);
?>

<section class="banner-section bg--theme--overlay">
    <div class="shapes-banner bg_img" data-background="<?php echo e(getImage('assets/images/frontend/banner/' . @$bannerContent->data_values->background_image, '1920x875')); ?>"></div>
    <div class="particles-js" id="particles-js"></div>

    <div class="banner-shape">
        <img src="<?php echo e(asset($activeTemplateTrue . 'images/wave.png')); ?>" alt="<?php echo app('translator')->get('banner'); ?>">
    </div>

    <div class="doge1 d-none d-lg-block">
        <img src="<?php echo e(getImage('assets/images/frontend/banner/' . @$bannerContent->data_values->image, '210x210')); ?>" alt="<?php echo app('translator')->get('doge1'); ?>">
    </div>
    <div class="doge2 d-none d-lg-block">
        <img src="<?php echo e(getImage('assets/images/frontend/banner/' . @$bannerContent->data_values->image, '210x210')); ?>" alt="<?php echo app('translator')->get('doge2'); ?>">
    </div>
    
    <div class="container">
        <div class="banner__content text--white">
           
            <h1 class="banner__title text--white"><?php echo e(__(@$bannerContent->data_values->subtitle)); ?></h1>
            <p class="banner__text"><?php echo e(__(@$bannerContent->data_values->description)); ?></p>
        </div>
        <div class="banner__bottom__content text--white">
            <div class="row justify-content-center">
                <div class="col-lg-7 col-md-10">
                    <form class="account__form" id="loginForm" action="#">
                        <?php echo csrf_field(); ?>
                        <div class="form-group position-relative">
                            <input class="form-control" name="wallet" type="text" placeholder="<?php echo app('translator')->get('Your Solana Wallet Address'); ?>">
                            <button class="cmn--btn" type="submit"><?php echo app('translator')->get('ENTER'); ?></button>
                        </div>
                    </form>
                    <h4 class="dogecoin__amount text--white"><span id="mined">0</span> <?php echo e(__($general->cur_text)); ?></h4>
                    <p class="banner__bottom__text">
    <?php echo app('translator')->get('MINER SPEED'); ?>: <span>100%</span> <?php echo app('translator')->get('DH/S'); ?> | 
    <?php echo app('translator')->get('THERAHASH'); ?>: <span id="dailyProfit"> <?php echo e(4 * $general->daily_earning); ?> </span> <?php echo e(__($general->cur_text)); ?><br>
    <?php echo app('translator')->get('Earn 3-5% profit daily with our mining platform!'); ?><br>
    <?php echo app('translator')->get('Referral commission available on 3 levels:'); ?><br>
    <?php echo app('translator')->get('Level 1 - 7% | Level 2 - 2% | Level 3 - 1%'); ?>
</p>

                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset($activeTemplateTrue . '/js/particles.min.js')); ?>"></script>
    <script src="<?php echo e($activeTemplateTrue . '/js/particle.js'); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            let dailyProfit = $('#dailyProfit').text();
            let dailyProfitInSeconds = dailyProfit / 864000;
            let minedAmount = 0;
            setInterval(function() {
                minedAmount += dailyProfitInSeconds;
                $('#mined').text(minedAmount.toFixed(8));
            }, 100);
            $('#loginForm').on('submit', function(e) {
                e.preventDefault();
                var data = $(this).serialize();
                var wallet = $(this).find('[name=wallet]').val();
                if (!wallet) {
                    notify('error', 'Wallet address is required')
                    return;
                }

                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('account.login')); ?>",
                    data: data,
                    dataType: "json",
                    success: function(response) {
                        if (response.error) {
                            notify('error', response.error)
                        } else {
                            notify('success', response.success)
                            setTimeout(function() {
                                window.location.href = "<?php echo e(route('account.home')); ?>";
                            }, 1000)
                        }
                    },
                    error: function(response) {
                        notify('warning', "The page is reloading to refresh the session.")
                        notify('error', "Session not found.")
                        setInterval(() => {
                            location.reload()
                        }, 2000);
                    }
                });
            })
            initParticles(`<?php echo e(getImage(getFilePath('logoIcon') . '/logo.png')); ?>`);
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/solana/public_html/4/core/resources/views/templates/basic/sections/banner.blade.php ENDPATH**/ ?>