<?php

namespace App\Http\Controllers;

use App\Constants\Status;
use App\Lib\CurlRequest;
use App\Models\Account;
use App\Models\Deposit;
use App\Models\Gateway;
use App\Models\ReferralLog;
use App\Models\Track;
use App\Models\Withdrawal;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class AccountController extends Controller
{

    public function home()
    {
        $account = session()->get('ACCOUNT');
        $account = Account::where('wallet', $account)->first();

        $general   = gs();
        $pageTitle = 'Dashboard';
        $track     = Track::where('account_id', $account->id)->where('status', Status::ACTIVE)->first();

        $diffInSecond = Carbon::now()->diffInSeconds($track->updated_at);

        $dailyEarning  = $track->speed * $general->dailyEarning;
        $perSecEarning = $dailyEarning / 86400;

        $total = round($diffInSecond * $perSecEarning, 8);

        $track->balance += $total;
        $track->save();

        $deposits     = Deposit::where('account_id', $account->id)->successful();
        $depositCount = $deposits->count();
        $depositTotal = $deposits->sum('amount');

        $withdraws     = Withdrawal::where('account_id', $account->id);
        $withdrawCount = $withdraws->count();
        $withdrawTotal = $withdraws->sum('amount');

        $referralCount = Account::where('ref_by', $account->id)->count();
        return view($this->activeTemplate . 'account.dashboard', compact('account', 'track', 'pageTitle', 'depositCount', 'depositTotal', 'withdrawCount', 'withdrawTotal', 'referralCount'));
    }

    public function deposit()
    {
        $pageTitle = 'Deposit';
        $account   = session()->get('ACCOUNT');
        $account   = Account::where('wallet', $account)->firstOrFail();
        $deposits  = Deposit::where('account_id', $account->id)->successful()->paginate(getPaginate());
        $gateway   = Gateway::findOrFail(1);
        return view($this->activeTemplate . 'account.deposit', compact('account', 'gateway', 'deposits', 'pageTitle'));
    }

    public function withdraw()
    {

        $general = gs();
        if (!$general->withdraw_system) {
            $notify[] = ['error', 'Withdraw system is not available now'];
            return back()->withNotify($notify);
        }

        $account     = session()->get('ACCOUNT');
        $account     = Account::where('wallet', $account)->firstOrFail();
        $pageTitle   = 'Withdraw';
        $track       = Track::where('account_id', $account->id)->firstOrFail();
        $withdrawals = Withdrawal::where('account_id', $account->id)->paginate(getPaginate());
        $gateway     = Gateway::findOrFail(1);

        return view($this->activeTemplate . 'account.withdraw', compact('account', 'gateway', 'withdrawals', 'track', 'pageTitle'));
    }

    public function referrals()
    {
        $general = gs();

        if (!$general->referral_system) {
            $notify[] = ['error', 'Referral system is not available now'];
            return back()->withNotify($notify);
        }

        $account      = session()->get('ACCOUNT');
        $account      = Account::where('wallet', $account)->first();
        $referralLogs = ReferralLog::where('account_id', $account->id)->with('referral')->paginate(getPaginate());
        $pageTitle    = 'My Referral';

        return view($this->activeTemplate . 'account.referrals', compact('account', 'pageTitle', 'referralLogs'));
    }

    public function login(Request $request)
    {
        $validate = Validator::make($request->except('_token'), [
            "wallet" => "required",
        ]);
        if ($validate->fails()) {
            return response()->json(['error' => $validate->errors()->all()]);
        }
        $response = CurlRequest::curlContent('https://dogechain.info/api/v1/address/balance/' . $request->wallet);
        $type     = json_decode($response);
        if (!$type->success) {
            return response()->json(['error' => 'Address is invalid']);
        } else {
            $account = Account::where('wallet', $request->wallet)->first();
            if ($account) {
                if ($account->status == 0) {
                    return response()->json(['error' => 'This account is banned by admin']);
                }
                session()->put('ACCOUNT', $request->wallet);
                return response()->json(['success' => 'Account found']);
            }
            $refId = session()->get('reference');

            if ($refId) {
                $refUser = Account::where('unique_id', $refId)->first();
                $refBy   = $refUser->id;
            }

            $account            = new Account();
            $account->ref_by    = $refBy ?? 0;
            $account->wallet    = $request->wallet;
            $account->unique_id = getUniqueId();
            $account->save();

            $general = gs();

            $track             = new Track();
            $track->account_id = $account->id;
            $track->speed      = $general->free_dhs;
            $track->balance    = 0;
            $track->save();

            session()->put('ACCOUNT', $request->wallet);
            session()->forget('REFER_BY');

            return response()->json(['success' => 'New account created successfully']);
        }
    }

    public function logout()
    {
        session()->forget('ACCOUNT');
        request()->session()->invalidate();
        return to_route('home');
    }
}
