<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Deposit;

class DepositController extends Controller
{

    public function index()
    {
        $pageTitle = 'Deposits';
        $deposits  = $this->depositData();
        return view('admin.deposit.index', compact('deposits', 'pageTitle'));
    }
    public function initiated()
    {
        $pageTitle = 'Deposits';
        $deposits  = $this->depositData('initiated');
        return view('admin.deposit.index', compact('deposits', 'pageTitle'));
    }
    public function successful()
    {
        $pageTitle = 'Deposits';
        $deposits  = $this->depositData('successful');
        return view('admin.deposit.index', compact('deposits', 'pageTitle'));
    }
    public function depositData($scope = null)
    {
        $deposits  = Deposit::dateFilter()->searchable(['trx', 'wallet', 'account:unique_id']);
        if ($scope) $deposits = $deposits->$scope();
        $deposits = $deposits->latest()->with('account')->paginate(getPaginate());
        return $deposits;
    }
}
