<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\Searchable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Account extends Model
{
    use HasFactory, Searchable;

    protected $guarded = ['id'];

    public function deposits()
    {
        return $this->hasMany(Deposit::class);
    }

    function referral()
    {
        return $this->hasOne(Account::class, 'id', 'ref_by');
    }

    public function withdrawals()
    {
        return $this->hasMany(Withdrawal::class);
    }
    public function track()
    {
        return $this->hasOne(Track::class);
    }
    public function referrals()
    {
        return $this->hasMany(ReferralLog::class);
    }
    public function scopeActive()
    {
        return $this->where('status', Status::ACCOUNT_ACTIVE);
    }

    public function scopeBanned()
    {
        return $this->where('status', Status::ACCOUNT_BAN);
    }
    public function scopeReferred()
    {
        return $this->where('ref_by', '!=', null)->orWhere('ref_by', '!=', 0);
    }
}
