@extends('admin.layouts.app')
@section('panel')
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive--sm table-responsive">
                <table class="table--light style--two table">
                    <thead>
                        <tr>
                            <th>@lang('Account ID')</th>
                            <th>@lang('Wallet')</th>
                            <th>@lang('Track Speed')</th>
                            <th>@lang('Referred By')</th>
                            @if (request()->routeIs('admin.account.index') || request()->routeIs('admin.account.referred'))
                                <th>@lang('Status')</th>
                            @endif
                            <th>@lang('Action')</th>
                        </tr>
                    </thead>
                    <tbody class="list">
                        @forelse ($accounts as $account)
                            <tr>
                                <td>{{ $account->unique_id }}</td>
                                <td>{{ $account->wallet }}</td>
                                <td>{{ @$account->track->speed }} @lang('DH/S')</td>
                                <td>
                                    @if ($account->ref_by)
                                        <a href="{{ route('admin.account.detail', $account->ref_by) }}">{{ $account->referral->unique_id }}</a>
                                    @else
                                        @lang('N/A')
                                    @endif
                                </td>
                                @if (request()->routeIs('admin.account.index') || request()->routeIs('admin.account.referred'))
                                    <td>
                                        @if ($account->status)
                                            <span class="badge badge--success">@lang('Activated')</span>
                                        @else
                                            <span class="badge badge--danger">@lang('Deactivated')</span>
                                        @endif
                                    </td>
                                @endif
                                <td>
                                    <a class="btn btn-sm btn-outline--primary editButton" href="{{ route('admin.account.detail', $account->id) }}">
                                        <i class="las la-desktop"></i> @lang('Detail')
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if ($accounts->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($accounts) }}
            </div>
        @endif
    </div>
@endsection
@push('breadcrumb-plugins')
    <x-search-form placeholder="Account ID / Wallet" />
@endpush
