@php
    $content = getContent('footer.content', true);
    $socialIcons = getContent('social_icon.element', false, null, true);
    $policyPages = getContent('policy_pages.element', false, null, true);
@endphp

<footer class="bg--theme--overlay footer-section bg_fixed bg_img" data-background="{{ getImage('assets/images/frontend/footer/' . @$content->data_values->image, '1920x826') }}">
    @if (Route::currentRouteName() == 'home' || Route::currentRouteName() == 'contact' || Route::currentRouteName() == 'blog')
        <div class="banner-shape-top">
            <img src="{{ asset($activeTemplateTrue . 'images/wave-rev.png') }}" alt="@lang('banner')">
        </div>
    @endif
    <div class="container">
        <div class="footer-top pt-120 @if (Route::currentRouteName() == 'home' || Route::currentRouteName() == 'contact' || Route::currentRouteName() == 'blog') top--wave-wrapper @endif pb-3">
            <div class="footer-logo">
                <a href="{{ route('home') }}">
                    <img src="{{ getImage(getFilePath('logoIcon') . '/logo.png') }}" alt="@lang('logo')">
                </a>
            </div>
            <p class="footer--text">{{ __(@$content->data_values->short_description) }}</p>
            <ul class="social__icons">
                @foreach ($socialIcons as $social)
                    <li>
                        <a class="facebook" href="{{ @$social->data_values->url }}">
                            @php echo @$social->data_values->social_icon; @endphp
                        </a>
                    </li>
                @endforeach
            </ul>

            <ul class="footer-links pt-5">
                @foreach ($policyPages as $policy)
                    <li class="p-0"><a href="{{ route('policy.pages', [slug(@$policy->data_values->title), $policy->id]) }}">{{ __($policy->data_values->title) }}</a></li>
                @endforeach
            </ul>
        </div>
        <div class="footer-bottom py-3">
            <div class="copyright text--white text-center">
                <span>@lang('Copyright') &copy; @php echo date('Y') @endphp . @lang('All Rights Reserved')</span>
            </div>
        </div>
    </div>
</footer>
