 <header class="header-section">
     <div class="container">
         <div class="header-wrapper">
             <div class="logo">
                 <a href="{{ route('home') }}">
                     <img src="{{ getImage(getFilePath('logoIcon') . '/logo.png') }}" alt="@lang('site-logo')">
                 </a>
             </div>
             <ul class="menu">
                 @if (!session('ACCOUNT'))
                     <li class="nav-item">
                         <a class="nav-link same-page" @if (request()->routeIs('home')) href="#how_work"  @else href="{{ route('home') }}#how_we_work" @endif>@lang('How To Start')</a>
                     </li>

                     <li class="nav-item">
                         <a class="nav-link same-page" @if (request()->routeIs('home')) href="#about-us" @else href="{{ route('home') }}#about-us" @endif>@lang('About Us')</a>
                     </li>
                     <li class="nav-item">
                         <a class="nav-link same-page" @if (request()->routeIs('home')) href="#transaction" @else href="{{ route('home') }}#transaction" @endif>@lang('Transactions')</a>
                     </li>

                     <li class="nav-item">
                         <a class="nav-link same-page" @if (request()->routeIs('home')) href="#faq"  @else href="{{ route('home') }}#faq" @endif>@lang('FAQ')</a>
                     </li>

                     <li class="nav-item">
                         <a class="nav-link" href="{{ route('blog') }}">@lang('Blog')</a>
                     </li>

                     <li class="nav-item">
                         <a class="nav-link" href="{{ route('contact') }}">@lang('Contact')</a>
                     </li>
                 @else
                     <li class="nav-item">
                         <a class="nav-link" href="{{ route('account.home') }}">@lang('Dashboard')</a>
                     </li>
                     <li class="nav-item">
                         <a class="nav-link" href="{{ route('account.deposit') }}">@lang('Deposit')</a>
                     </li>

                     @if ($general->withdraw_system)
                         <li class="nav-item">
                             <a class="nav-link" href="{{ route('account.withdraw') }}">@lang('Withdraw')</a>
                         </li>
                     @endif

                     @if ($general->referral_system)
                         <li class="nav-item">
                             <a class="nav-link" href="{{ route('account.referrals') }}">@lang('Referral')</a>
                         </li>
                     @endif

                     <li class="nav-item">
                         <a class="nav-link" href="{{ route('account.logout') }}">@lang('Logout')</a>
                     </li>

                 @endif
             </ul>
             <select class="select-bar langSel">
                 @foreach ($language as $lang)
                     <option value="{{ $lang->code }}" @selected(session('lang') == $lang->code)> {{ __($lang->name) }} </option>
                 @endforeach
             </select>
             <div class="header-bar m-0">
                 <span></span>
                 <span></span>
                 <span></span>
             </div>
         </div>
     </div>
 </header>

 @if (request()->routeIs('home'))
     @push('script')
         <script>
             "use strict";
             (function($) {
                 $('.same-page').on('click', function() {
                     $('.menu').removeClass('active');
                     $('.header-bar').removeClass('active');
                     $('.overlay').removeClass('active');
                 });
             })(jQuery);
         </script>
     @endpush
 @endif
