@php
    $content = getContent('feature.content', true);
    $elements = getContent('feature.element', false, null, true);
@endphp
<section class="feature-section pt-120 pb-120 bg--theme--overlay top--wave-wrapper bottom--wave-wrapper bg_img bg_fixed" data-background="{{ getImage('assets/images/frontend/feature/' . @$content->data_values->background_image, '1920x1280') }}">
    <div class="banner-shape">
        <img src="{{ asset($activeTemplateTrue . 'images/wave.png') }}" alt="@lang('banner')">
    </div>
    <div class="banner-shape-top">
        <img src="{{ asset($activeTemplateTrue . 'images/wave-rev.png') }}" alt="@lang('banner')">
    </div>
    <div class="container">
        <div class="section__header section__header__center text--white">
            <span class="section__cate">
                {{ __(@$content->data_values->title) }}
            </span>
            <h3 class="text--white pb-3">{{ __(@$content->data_values->subtitle) }}</h3>
            <p>{{ __(@$content->data_values->description) }}</p>
        </div>
        <div class="row g-4 justify-content-center">
            @foreach ($elements as $element)
                <div class="col-md-6 col-lg-4">
                    <div class="feature__item">
                        <div class="feature__icon">
                            @php echo $element->data_values->icon @endphp
                        </div>
                        <div class="feature__content">
                            <h5 class="feature__title">{{ __(@$element->data_values->title) }}</h5>
                            <p class="text-white">
                                {{ __(@$element->data_values->description) }}
                            </p>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
