<?php

use App\Lib\Router;
use App\Notify\Email;
use Illuminate\Support\Facades\Route;


Route::get('/clear', function () {
    \Illuminate\Support\Facades\Artisan::call('optimize:clear');
});

Route::get('/cron', 'CronController@cron')->name('cron');
Route::post('ipn/coinPayment/deposit', 'PaymentController@ipnDeposit')->name('ipn.coinPayment.deposit');

Route::name('account.')->prefix('account')->group(function () {
    Route::controller('AccountController')->group(function () {
        Route::post('login', 'login')->name('login');
        Route::get('/logout', 'logout')->name('logout');
    });

    Route::middleware('account')->controller('AccountController')->group(function () {
        Route::get('dashboard', 'home')->name('home');
        Route::get('deposit', 'deposit')->name('deposit');
        Route::get('withdraw', 'withdraw')->name('withdraw');
        Route::get('/referrals', 'referrals')->name('referrals');
    });
    Route::middleware('account')->controller('PaymentController')->group(function () {
        Route::post('deposit', 'depositWallet')->name('deposit');
        Route::post('withdraw', 'withdrawMoney')->name('withdraw');
    });
});

Route::controller('SiteController')->group(function () {
    Route::get('policy/{slug}/{id}', 'policyPages')->name('policy.pages');
    Route::get('placeholder-image/{size}', 'placeholderImage')->name('placeholder.image');


    Route::get('/change/{lang?}', 'changeLanguage')->name('lang');

    Route::get('cookie-policy', 'cookiePolicy')->name('cookie.policy');
    Route::get('/cookie/accept', 'cookieAccept')->name('cookie.accept');

    Route::middleware('account.guest')->group(function () {
        Route::get('/contact', 'contact')->name('contact');
        Route::post('/contact', 'contactSubmit');

        Route::get('/blog', 'blog')->name('blog');
        Route::get('blog/{slug}/{id}', 'blogDetails')->name('blog.details');

        Route::get('/', 'index')->name('home');
    });
});
